/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.xa;

import java.util.logging.Logger;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.jboss.as.quickstarts.xa.XAService;

@MessageDriven(name="DbUpdaterMDB", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/jta-crash-rec-quickstart"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class DbUpdaterMDB
implements MessageListener {
    private static final Logger LOGGER = Logger.getLogger(DbUpdaterMDB.class.getName());
    @Inject
    private XAService xaService;

    public void onMessage(Message rcvMessage) {
        LOGGER.info("Received Message: " + rcvMessage.toString());
        try {
            if (rcvMessage instanceof TextMessage) {
                TextMessage msg = (TextMessage)rcvMessage;
                String sm = msg.getText();
                String[] kvPair = sm.split("=");
                if (kvPair.length == 2 && kvPair[0].length() != 0) {
                    this.xaService.modifyKeyValueTable(false, kvPair[0], kvPair[1] + " updated via JMS");
                    LOGGER.info("JTA Crash Record Quickstart: key value pair updated via JMS");
                }
            } else {
                LOGGER.warning("JTA Crash Record Quickstart: Unexpected message. Type: " + rcvMessage.getClass().getName());
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }
}

