/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.html5_mobile.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.quickstarts.html5_mobile.util.JSONPRequestFilter;

@WebFilter(value={"/rest/*"})
public class JSONPRequestFilter
implements Filter {
    private static final String CALLBACK_METHOD = "jsonpcallback";
    public static final Pattern SAFE_PRN = Pattern.compile("[a-zA-Z0-9_\\.]+");
    public static final String CONTENT_TYPE = "application/javascript";

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Only HttpServletRequest requests are supported");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String callback = this.getCallbackMethod(httpRequest);
        if (!this.isJSONPRequest(callback)) {
            chain.doFilter(request, response);
        } else {
            if (!SAFE_PRN.matcher(callback).matches()) {
                throw new ServletException("JSONP Callback method 'jsonpcallback' parameter not valid function");
            }
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            1 responseWrapper = new /* Unavailable Anonymous Inner Class!! */;
            chain.doFilter(request, (ServletResponse)responseWrapper);
            response.setContentType(CONTENT_TYPE);
            response.setCharacterEncoding("UTF-8");
            response.getOutputStream().write((callback + "(").getBytes());
            response.getOutputStream().write(byteStream.toByteArray());
            response.getOutputStream().write(");".getBytes());
        }
    }

    private String getCallbackMethod(HttpServletRequest httpRequest) {
        return httpRequest.getParameter(CALLBACK_METHOD);
    }

    private boolean isJSONPRequest(String callbackMethod) {
        return callbackMethod != null && callbackMethod.length() > 0;
    }

    public void destroy() {
    }
}

