/*
 * JBoss, Home of Professional Open Source
 * Copyright 2015, Red Hat, Inc. and/or its affiliates, and individual
 * contributors by the @authors tag. See the copyright.txt in the
 * distribution for a full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.as.quickstarts.ejb_security_interceptors;

import org.jboss.ejb.client.annotation.ClientInterceptors;

/**
 * The interface used to access the SecuredEJB
 *
 * @author <a href="mailto:darran.lofthouse@jboss.com">Darran Lofthouse</a>
 */
@ClientInterceptors(ClientSecurityInterceptor.class)
public interface SecuredEJBRemote {

    /**
     * @return A String containing the name of the current principal and also confirmation of role membership.
     */
    String getSecurityInformation();

    /**
     * A method that is only invokable if the user has the role 'RoleOne'.
     */
    boolean roleOneMethod();

    /**
     * A method that is only invokable if the user has the role 'RoleTwo'.
     */
    boolean roleTwoMethod();

}
