/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.jaxrs.client;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class JaxRsClient {
    private static String XML_URL;
    private static String JSON_URL;
    private static final String XML_PROPERTY = "xmlUrl";
    private static final String JSON_PROPERTY = "jsonUrl";
    private static final String XML_RESPONSE = "<xml><result>Hello World!</result></xml>";
    private static final String JSON_RESPONSE = "{\"result\":\"Hello World!\"}";

    public static void main(String[] args) {
        XML_URL = System.getProperty(XML_PROPERTY);
        JSON_URL = System.getProperty(JSON_PROPERTY);
        new JaxRsClient().test();
    }

    void test() {
        String response = this.runRequest(XML_URL, MediaType.APPLICATION_XML_TYPE);
        if (!XML_RESPONSE.equals(response)) {
            throw new RuntimeException("Response is wrong:\nXML Response:" + response + "\nshould be: " + XML_RESPONSE);
        }
        response = this.runRequest(JSON_URL, MediaType.APPLICATION_JSON_TYPE);
        if (!JSON_RESPONSE.equals(response)) {
            throw new RuntimeException("Response is wrong:\nJSON Response:" + response + "\nshould be: " + JSON_RESPONSE);
        }
    }

    private String runRequest(String url, MediaType mediaType) {
        String result = null;
        System.out.println("===============================================");
        System.out.println("URL: " + url);
        System.out.println("MediaType: " + mediaType.toString());
        ResteasyClient client = new ResteasyClientBuilder().build();
        ResteasyWebTarget target = client.target(url);
        target.request(new MediaType[]{mediaType});
        Response response = target.request().get();
        result = (String)response.readEntity(String.class);
        response.close();
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed request with HTTP status: " + response.getStatus());
        }
        System.out.println("\n*** Response from Server ***\n");
        System.out.println(result);
        System.out.println("\n===============================================");
        return result;
    }
}

