/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.controller;

import java.io.IOException;
import javax.persistence.NoResultException;
import javax.validation.Valid;
import org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.data.MemberDao;
import org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.model.Member;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/"})
public class MemberController {
    @Autowired
    private MemberDao memberDao;

    @RequestMapping(method={RequestMethod.GET})
    public String displaySortedMembers(Model model) {
        model.addAttribute("newMember", (Object)new Member());
        return "index";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String registerNewMember(@Valid @ModelAttribute(value="newMember") Member newMember, BindingResult result, Model model) {
        if (!result.hasErrors()) {
            try {
                this.memberDao.register(newMember);
                return "redirect:/";
            }
            catch (UnexpectedRollbackException e) {
                if (this.emailAlreadyExists(newMember.getEmail())) {
                    model.addAttribute("error", (Object)"Unique Email Violation");
                } else {
                    model.addAttribute("error", (Object)e.getCause().getCause());
                }
                return "index";
            }
        }
        return "index";
    }

    @RequestMapping(value={"error/"}, method={RequestMethod.POST})
    public void postError() throws IOException {
        throw new IOException();
    }

    public boolean emailAlreadyExists(String email) {
        Member member = null;
        try {
            member = this.memberDao.findByEmail(email);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return member != null;
    }
}

