/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.controller;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.data.MemberDao;
import org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.model.Member;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class MemberControllerAdvice {
    @Autowired
    private MemberDao memberDao;

    private String getStackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    @ExceptionHandler(value={IOException.class})
    public ModelAndView exception(IOException e) {
        ModelAndView model = new ModelAndView("error");
        model.addObject("error", (Object)this.getStackTrace((Exception)e));
        return model;
    }

    @InitBinder
    public void binder(WebDataBinder dataBinder, WebRequest request) {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)format, true);
        dataBinder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @ModelAttribute(value="members")
    public List<Member> getMembers() {
        return this.memberDao.findAllOrderedByName();
    }
}

