/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.format.annotation.DateTimeFormat;

@Entity
@Table(name="MemberControllerAdvice", uniqueConstraints={@UniqueConstraint(columnNames={"email"})})
public class Member
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Long id;
    @NotNull
    @Size(min=1, max=25)
    @Pattern(regexp="[A-Za-z ]*", message="must contain only letters and spaces")
    private String name;
    @NotNull
    @NotEmpty(message="Email address cannot be empty")
    @Email(message="Invalid email address, e.g. valid email address: example@gmail.com")
    private String email;
    @NotNull
    @Size(min=10, max=12)
    @Digits(fraction=0, integer=12, message="Incorrect Format, valid e.g. 121212121212")
    @Column(name="phone_number")
    private String phoneNumber;
    @NotNull
    @Column(name="date_created")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date date;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

