/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.beans.support.SortDefinition;
import org.springframework.core.style.ToStringCreator;
import org.springframework.samples.petclinic.model.Person;
import org.springframework.samples.petclinic.model.Pet;

@Entity
@Table(name="owners")
public class Owner
extends Person {
    @Column(name="address")
    @NotEmpty
    private String address;
    @Column(name="city")
    @NotEmpty
    private String city;
    @Column(name="telephone")
    @NotEmpty
    @Digits(fraction=0, integer=10)
    private String telephone;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    private Set<Pet> pets;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    protected Set<Pet> getPetsInternal() {
        if (this.pets == null) {
            this.pets = new HashSet();
        }
        return this.pets;
    }

    protected void setPetsInternal(Set<Pet> pets) {
        this.pets = pets;
    }

    public List<Pet> getPets() {
        ArrayList sortedPets = new ArrayList(this.getPetsInternal());
        PropertyComparator.sort(sortedPets, (SortDefinition)new MutableSortDefinition("name", true, true));
        return Collections.unmodifiableList(sortedPets);
    }

    public void addPet(Pet pet) {
        this.getPetsInternal().add(pet);
        pet.setOwner(this);
    }

    public Pet getPet(String name) {
        return this.getPet(name, false);
    }

    public Pet getPet(String name, boolean ignoreNew) {
        name = name.toLowerCase();
        for (Pet pet : this.getPetsInternal()) {
            if (ignoreNew && pet.isNew()) continue;
            String compName = pet.getName();
            if (!(compName = compName.toLowerCase()).equals(name)) continue;
            return pet;
        }
        return null;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("new", this.isNew()).append("lastName", (Object)this.getLastName()).append("firstName", (Object)this.getFirstName()).append("address", (Object)this.address).append("city", (Object)this.city).append("telephone", (Object)this.telephone).toString();
    }
}

