/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.beans.support.SortDefinition;
import org.springframework.samples.petclinic.model.Person;
import org.springframework.samples.petclinic.model.Specialty;

@Entity
@Table(name="vets")
public class Vet
extends Person {
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="vet_specialties", joinColumns={@JoinColumn(name="vet_id")}, inverseJoinColumns={@JoinColumn(name="specialty_id")})
    private Set<Specialty> specialties;

    protected Set<Specialty> getSpecialtiesInternal() {
        if (this.specialties == null) {
            this.specialties = new HashSet();
        }
        return this.specialties;
    }

    protected void setSpecialtiesInternal(Set<Specialty> specialties) {
        this.specialties = specialties;
    }

    @XmlElement
    public List<Specialty> getSpecialties() {
        ArrayList sortedSpecs = new ArrayList(this.getSpecialtiesInternal());
        PropertyComparator.sort(sortedSpecs, (SortDefinition)new MutableSortDefinition("name", true, true));
        return Collections.unmodifiableList(sortedSpecs);
    }

    public int getNrOfSpecialties() {
        return this.getSpecialtiesInternal().size();
    }

    public void addSpecialty(Specialty specialty) {
        this.getSpecialtiesInternal().add(specialty);
    }
}

