/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.repository.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.data.jdbc.core.OneToManyResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.samples.petclinic.model.Visit;
import org.springframework.samples.petclinic.repository.jdbc.JdbcPet;
import org.springframework.samples.petclinic.repository.jdbc.JdbcPetRowMapper;
import org.springframework.samples.petclinic.repository.jdbc.JdbcVisitRowMapper;

public class JdbcPetVisitExtractor
extends OneToManyResultSetExtractor<JdbcPet, Visit, Integer> {
    public JdbcPetVisitExtractor() {
        super((RowMapper)new JdbcPetRowMapper(), (RowMapper)new JdbcVisitRowMapper());
    }

    protected Integer mapPrimaryKey(ResultSet rs) throws SQLException {
        return rs.getInt("pets.id");
    }

    protected Integer mapForeignKey(ResultSet rs) throws SQLException {
        if (rs.getObject("visits.pet_id") == null) {
            return null;
        }
        return rs.getInt("visits.pet_id");
    }

    protected void addChild(JdbcPet root, Visit child) {
        root.addVisit(child);
    }
}

