/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.repository.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.samples.petclinic.model.Specialty;
import org.springframework.samples.petclinic.model.Vet;
import org.springframework.samples.petclinic.repository.VetRepository;
import org.springframework.samples.petclinic.util.EntityUtils;
import org.springframework.stereotype.Repository;

@Repository
public class JdbcVetRepositoryImpl
implements VetRepository {
    private JdbcTemplate jdbcTemplate;

    @Autowired
    public JdbcVetRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<Vet> findAll() throws DataAccessException {
        ArrayList<Vet> vets = new ArrayList<Vet>();
        vets.addAll(this.jdbcTemplate.query("SELECT id, first_name, last_name FROM vets ORDER BY last_name,first_name", (RowMapper)BeanPropertyRowMapper.newInstance(Vet.class)));
        List specialties = this.jdbcTemplate.query("SELECT id, name FROM specialties", (RowMapper)BeanPropertyRowMapper.newInstance(Specialty.class));
        for (Vet vet : vets) {
            List vetSpecialtiesIds = this.jdbcTemplate.query("SELECT specialty_id FROM vet_specialties WHERE vet_id=?", (RowMapper)new /* Unavailable Anonymous Inner Class!! */, new Object[]{vet.getId()});
            Iterator iterator = vetSpecialtiesIds.iterator();
            while (iterator.hasNext()) {
                int specialtyId = (Integer)iterator.next();
                Specialty specialty = (Specialty)EntityUtils.getById((Collection)specialties, Specialty.class, (int)specialtyId);
                vet.addSpecialty(specialty);
            }
        }
        return vets;
    }
}

