/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.repository.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.samples.petclinic.model.Pet;
import org.springframework.samples.petclinic.model.PetType;
import org.springframework.samples.petclinic.repository.PetRepository;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPetRepositoryImpl
implements PetRepository {
    @PersistenceContext
    private EntityManager em;

    public List<PetType> findPetTypes() {
        return this.em.createQuery("SELECT ptype FROM PetType ptype ORDER BY ptype.name").getResultList();
    }

    public Pet findById(int id) {
        return (Pet)this.em.find(Pet.class, (Object)id);
    }

    public void save(Pet pet) {
        if (pet.getId() == null) {
            this.em.persist((Object)pet);
        } else {
            this.em.merge((Object)pet);
        }
    }
}

