/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.util;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.StopWatch;

@ManagedResource(value="petclinic:type=CallMonitor")
@Aspect
public class CallMonitoringAspect {
    private boolean enabled = true;
    private int callCount = 0;
    private long accumulatedCallTime = 0L;

    @ManagedAttribute
    public boolean isEnabled() {
        return this.enabled;
    }

    @ManagedAttribute
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @ManagedOperation
    public void reset() {
        this.callCount = 0;
        this.accumulatedCallTime = 0L;
    }

    @ManagedAttribute
    public int getCallCount() {
        return this.callCount;
    }

    @ManagedAttribute
    public long getCallTime() {
        if (this.callCount > 0) {
            return this.accumulatedCallTime / (long)this.callCount;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="within(@org.springframework.stereotype.Repository *)")
    public Object invoke(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.enabled) {
            StopWatch sw = new StopWatch(joinPoint.toShortString());
            sw.start("invoke");
            try {
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                sw.stop();
                CallMonitoringAspect callMonitoringAspect = this;
                synchronized (callMonitoringAspect) {
                    ++this.callCount;
                    this.accumulatedCallTime += sw.getTotalTimeMillis();
                }
            }
        }
        return joinPoint.proceed();
    }
}

