/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.web;

import java.util.Collection;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.samples.petclinic.model.Owner;
import org.springframework.samples.petclinic.service.ClinicService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class OwnerController {
    private final ClinicService clinicService;

    @Autowired
    public OwnerController(ClinicService clinicService) {
        this.clinicService = clinicService;
    }

    @InitBinder
    public void setAllowedFields(WebDataBinder dataBinder) {
        dataBinder.setDisallowedFields(new String[]{"id"});
    }

    @RequestMapping(value={"/owners/new"}, method={RequestMethod.GET})
    public String initCreationForm(Map<String, Object> model) {
        Owner owner = new Owner();
        model.put("owner", owner);
        return "owners/createOrUpdateOwnerForm";
    }

    @RequestMapping(value={"/owners/new"}, method={RequestMethod.POST})
    public String processCreationForm(@Valid Owner owner, BindingResult result) {
        if (result.hasErrors()) {
            return "owners/createOrUpdateOwnerForm";
        }
        this.clinicService.saveOwner(owner);
        return "redirect:/owners/" + owner.getId();
    }

    @RequestMapping(value={"/owners/find"}, method={RequestMethod.GET})
    public String initFindForm(Map<String, Object> model) {
        model.put("owner", new Owner());
        return "owners/findOwners";
    }

    @RequestMapping(value={"/owners"}, method={RequestMethod.GET})
    public String processFindForm(Owner owner, BindingResult result, Map<String, Object> model) {
        Collection results;
        if (owner.getLastName() == null) {
            owner.setLastName("");
        }
        if ((results = this.clinicService.findOwnerByLastName(owner.getLastName())).isEmpty()) {
            result.rejectValue("lastName", "notFound", "not found");
            return "owners/findOwners";
        }
        if (results.size() == 1) {
            owner = (Owner)results.iterator().next();
            return "redirect:/owners/" + owner.getId();
        }
        model.put("selections", results);
        return "owners/ownersList";
    }

    @RequestMapping(value={"/owners/{ownerId}/edit"}, method={RequestMethod.GET})
    public String initUpdateOwnerForm(@PathVariable(value="ownerId") int ownerId, Model model) {
        Owner owner = this.clinicService.findOwnerById(ownerId);
        model.addAttribute((Object)owner);
        return "owners/createOrUpdateOwnerForm";
    }

    @RequestMapping(value={"/owners/{ownerId}/edit"}, method={RequestMethod.POST})
    public String processUpdateOwnerForm(@Valid Owner owner, BindingResult result, @PathVariable(value="ownerId") int ownerId) {
        if (result.hasErrors()) {
            return "owners/createOrUpdateOwnerForm";
        }
        owner.setId(Integer.valueOf(ownerId));
        this.clinicService.saveOwner(owner);
        return "redirect:/owners/{ownerId}";
    }

    @RequestMapping(value={"/owners/{ownerId}"})
    public ModelAndView showOwner(@PathVariable(value="ownerId") int ownerId) {
        ModelAndView mav = new ModelAndView("owners/ownerDetails");
        mav.addObject((Object)this.clinicService.findOwnerById(ownerId));
        return mav;
    }
}

