/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.web;

import java.util.Collection;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.samples.petclinic.model.Owner;
import org.springframework.samples.petclinic.model.Pet;
import org.springframework.samples.petclinic.model.PetType;
import org.springframework.samples.petclinic.service.ClinicService;
import org.springframework.samples.petclinic.web.PetValidator;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/owners/{ownerId}"})
public class PetController {
    private final ClinicService clinicService;

    @Autowired
    public PetController(ClinicService clinicService) {
        this.clinicService = clinicService;
    }

    @ModelAttribute(value="types")
    public Collection<PetType> populatePetTypes() {
        return this.clinicService.findPetTypes();
    }

    @ModelAttribute(value="owner")
    public Owner findOwner(@PathVariable(value="ownerId") int ownerId) {
        Owner owner = this.clinicService.findOwnerById(ownerId);
        return owner;
    }

    @InitBinder(value={"owner"})
    public void initOwnerBinder(WebDataBinder dataBinder) {
        dataBinder.setDisallowedFields(new String[]{"id"});
    }

    @InitBinder(value={"pet"})
    public void initPetBinder(WebDataBinder dataBinder) {
        dataBinder.setValidator((Validator)new PetValidator());
    }

    @RequestMapping(value={"/pets/new"}, method={RequestMethod.GET})
    public String initCreationForm(Owner owner, ModelMap model) {
        Pet pet = new Pet();
        owner.addPet(pet);
        model.put((Object)"pet", (Object)pet);
        return "pets/createOrUpdatePetForm";
    }

    @RequestMapping(value={"/pets/new"}, method={RequestMethod.POST})
    public String processCreationForm(Owner owner, @Valid Pet pet, BindingResult result, ModelMap model) {
        if (StringUtils.hasLength((String)pet.getName()) && pet.isNew() && owner.getPet(pet.getName(), true) != null) {
            result.rejectValue("name", "duplicate", "already exists");
        }
        if (result.hasErrors()) {
            model.put((Object)"pet", (Object)pet);
            return "pets/createOrUpdatePetForm";
        }
        owner.addPet(pet);
        this.clinicService.savePet(pet);
        return "redirect:/owners/{ownerId}";
    }

    @RequestMapping(value={"/pets/{petId}/edit"}, method={RequestMethod.GET})
    public String initUpdateForm(@PathVariable(value="petId") int petId, ModelMap model) {
        Pet pet = this.clinicService.findPetById(petId);
        model.put((Object)"pet", (Object)pet);
        return "pets/createOrUpdatePetForm";
    }

    @RequestMapping(value={"/pets/{petId}/edit"}, method={RequestMethod.POST})
    public String processUpdateForm(@Valid Pet pet, BindingResult result, Owner owner, ModelMap model) {
        if (result.hasErrors()) {
            model.put((Object)"pet", (Object)pet);
            return "pets/createOrUpdatePetForm";
        }
        owner.addPet(pet);
        this.clinicService.savePet(pet);
        return "redirect:/owners/{ownerId}";
    }
}

