/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.web;

import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.samples.petclinic.model.Pet;
import org.springframework.samples.petclinic.model.Visit;
import org.springframework.samples.petclinic.service.ClinicService;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class VisitController {
    private final ClinicService clinicService;

    @Autowired
    public VisitController(ClinicService clinicService) {
        this.clinicService = clinicService;
    }

    @InitBinder
    public void setAllowedFields(WebDataBinder dataBinder) {
        dataBinder.setDisallowedFields(new String[]{"id"});
    }

    @ModelAttribute(value="visit")
    public Visit loadPetWithVisit(@PathVariable(value="petId") int petId) {
        Pet pet = this.clinicService.findPetById(petId);
        Visit visit = new Visit();
        pet.addVisit(visit);
        return visit;
    }

    @RequestMapping(value={"/owners/*/pets/{petId}/visits/new"}, method={RequestMethod.GET})
    public String initNewVisitForm(@PathVariable(value="petId") int petId, Map<String, Object> model) {
        return "pets/createOrUpdateVisitForm";
    }

    @RequestMapping(value={"/owners/{ownerId}/pets/{petId}/visits/new"}, method={RequestMethod.POST})
    public String processNewVisitForm(@Valid Visit visit, BindingResult result) {
        if (result.hasErrors()) {
            return "pets/createOrUpdateVisitForm";
        }
        this.clinicService.saveVisit(visit);
        return "redirect:/owners/{ownerId}";
    }

    @RequestMapping(value={"/owners/*/pets/{petId}/visits"}, method={RequestMethod.GET})
    public String showVisits(@PathVariable int petId, Map<String, Object> model) {
        model.put("visits", this.clinicService.findPetById(petId).getVisits());
        return "visitList";
    }
}

