/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.repository.jdbc;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.samples.petclinic.model.Owner;
import org.springframework.samples.petclinic.model.Pet;
import org.springframework.samples.petclinic.model.PetType;
import org.springframework.samples.petclinic.repository.OwnerRepository;
import org.springframework.samples.petclinic.repository.jdbc.JdbcPet;
import org.springframework.samples.petclinic.repository.jdbc.JdbcPetVisitExtractor;
import org.springframework.samples.petclinic.util.EntityUtils;
import org.springframework.stereotype.Repository;

@Repository
public class JdbcOwnerRepositoryImpl
implements OwnerRepository {
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private SimpleJdbcInsert insertOwner;

    @Autowired
    public JdbcOwnerRepositoryImpl(DataSource dataSource, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.insertOwner = new SimpleJdbcInsert(dataSource).withTableName("owners").usingGeneratedKeyColumns(new String[]{"id"});
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public Collection<Owner> findByLastName(String lastName) throws DataAccessException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lastName", lastName + "%");
        List owners = this.namedParameterJdbcTemplate.query("SELECT id, first_name, last_name, address, city, telephone FROM owners WHERE last_name like :lastName", params, (RowMapper)BeanPropertyRowMapper.newInstance(Owner.class));
        this.loadOwnersPetsAndVisits(owners);
        return owners;
    }

    public Owner findById(int id) throws DataAccessException {
        Owner owner;
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("id", id);
            owner = (Owner)this.namedParameterJdbcTemplate.queryForObject("SELECT id, first_name, last_name, address, city, telephone FROM owners WHERE id= :id", params, (RowMapper)BeanPropertyRowMapper.newInstance(Owner.class));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new ObjectRetrievalFailureException(Owner.class, (Object)id);
        }
        this.loadPetsAndVisits(owner);
        return owner;
    }

    public void loadPetsAndVisits(Owner owner) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("id", owner.getId());
        List pets = (List)this.namedParameterJdbcTemplate.query("SELECT pets.id, name, birth_date, type_id, owner_id, visits.id as visit_id, visit_date, description, pet_id FROM pets LEFT OUTER JOIN visits ON  pets.id = pet_id WHERE owner_id=:id", params, (ResultSetExtractor)new JdbcPetVisitExtractor());
        Collection petTypes = this.getPetTypes();
        for (JdbcPet pet : pets) {
            pet.setType((PetType)EntityUtils.getById((Collection)petTypes, PetType.class, (int)pet.getTypeId()));
            owner.addPet((Pet)pet);
        }
    }

    public void save(Owner owner) throws DataAccessException {
        BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource((Object)owner);
        if (owner.isNew()) {
            Number newKey = this.insertOwner.executeAndReturnKey((SqlParameterSource)parameterSource);
            owner.setId(Integer.valueOf(newKey.intValue()));
        } else {
            this.namedParameterJdbcTemplate.update("UPDATE owners SET first_name=:firstName, last_name=:lastName, address=:address, city=:city, telephone=:telephone WHERE id=:id", (SqlParameterSource)parameterSource);
        }
    }

    public Collection<PetType> getPetTypes() throws DataAccessException {
        return this.namedParameterJdbcTemplate.query("SELECT id, name FROM types ORDER BY name", new HashMap(), (RowMapper)BeanPropertyRowMapper.newInstance(PetType.class));
    }

    private void loadOwnersPetsAndVisits(List<Owner> owners) {
        for (Owner owner : owners) {
            this.loadPetsAndVisits(owner);
        }
    }
}

