/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.repository.jdbc;

import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.samples.petclinic.model.Visit;
import org.springframework.samples.petclinic.repository.VisitRepository;
import org.springframework.samples.petclinic.repository.jdbc.JdbcVisitRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class JdbcVisitRepositoryImpl
implements VisitRepository {
    private JdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert insertVisit;

    @Autowired
    public JdbcVisitRepositoryImpl(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.insertVisit = new SimpleJdbcInsert(dataSource).withTableName("visits").usingGeneratedKeyColumns(new String[]{"id"});
    }

    public void save(Visit visit) throws DataAccessException {
        if (!visit.isNew()) {
            throw new UnsupportedOperationException("Visit update not supported");
        }
        Number newKey = this.insertVisit.executeAndReturnKey((SqlParameterSource)this.createVisitParameterSource(visit));
        visit.setId(Integer.valueOf(newKey.intValue()));
    }

    private MapSqlParameterSource createVisitParameterSource(Visit visit) {
        return new MapSqlParameterSource().addValue("id", (Object)visit.getId()).addValue("visit_date", (Object)visit.getDate().toDate()).addValue("description", (Object)visit.getDescription()).addValue("pet_id", (Object)visit.getPet().getId());
    }

    public List<Visit> findByPetId(Integer petId) {
        return this.jdbcTemplate.query("SELECT id as visit_id, visit_date, description FROM visits WHERE pet_id=?", (RowMapper)new JdbcVisitRowMapper(), new Object[]{petId});
    }
}

