/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.repository.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.samples.petclinic.model.Owner;
import org.springframework.samples.petclinic.repository.OwnerRepository;
import org.springframework.stereotype.Repository;

@Repository
public class JpaOwnerRepositoryImpl
implements OwnerRepository {
    @PersistenceContext
    private EntityManager em;

    public Collection<Owner> findByLastName(String lastName) {
        Query query = this.em.createQuery("SELECT DISTINCT owner FROM Owner owner left join fetch owner.pets WHERE owner.lastName LIKE :lastName");
        query.setParameter("lastName", (Object)(lastName + "%"));
        return query.getResultList();
    }

    public Owner findById(int id) {
        Query query = this.em.createQuery("SELECT owner FROM Owner owner left join fetch owner.pets WHERE owner.id =:id");
        query.setParameter("id", (Object)id);
        return (Owner)query.getSingleResult();
    }

    public void save(Owner owner) {
        if (owner.getId() == null) {
            this.em.persist((Object)owner);
        } else {
            this.em.merge((Object)owner);
        }
    }
}

