/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.web;

import java.text.ParseException;
import java.util.Collection;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.Formatter;
import org.springframework.samples.petclinic.model.PetType;
import org.springframework.samples.petclinic.service.ClinicService;

public class PetTypeFormatter
implements Formatter<PetType> {
    private final ClinicService clinicService;

    @Autowired
    public PetTypeFormatter(ClinicService clinicService) {
        this.clinicService = clinicService;
    }

    public String print(PetType petType, Locale locale) {
        return petType.getName();
    }

    public PetType parse(String text, Locale locale) throws ParseException {
        Collection findPetTypes = this.clinicService.findPetTypes();
        for (PetType type : findPetTypes) {
            if (!type.getName().equals(text)) continue;
            return type;
        }
        throw new ParseException("type not found: " + text, 0);
    }
}

