/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.web;

import org.springframework.samples.petclinic.model.Pet;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class PetValidator
implements Validator {
    public void validate(Object obj, Errors errors) {
        Pet pet = (Pet)obj;
        String name = pet.getName();
        if (!StringUtils.hasLength((String)name)) {
            errors.rejectValue("name", "required", "required");
        }
        if (pet.isNew() && pet.getType() == null) {
            errors.rejectValue("type", "required", "required");
        }
        if (pet.getBirthDate() == null) {
            errors.rejectValue("birthDate", "required", "required");
        }
    }

    public boolean supports(Class<?> clazz) {
        return Pet.class.isAssignableFrom(clazz);
    }
}

