/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.resteasyspring;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.as.quickstarts.resteasyspring.GreetingBean;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/")
public class HelloSpringResource {
    @Autowired
    GreetingBean greetingBean;

    @GET
    @Produces(value={"text/html"})
    public Response getDefault() {
        String msg = "Hello. <br> Please try <a href='http://localhost:8080/spring-resteasy/hello?name=yourname'>spring-resteasy/hello?name=yourname</a><br> Or try <a href='http://localhost:8080/spring-resteasy/basic'>spring-resteasy/basic</a><br> Or try <a href='http://localhost:8080/spring-resteasy/queryParam?param=query'>spring-resteasy/queryParam?param=query</a><br> Or try <a href='http://localhost:8080/spring-resteasy/matrixParam;param=matrix'>spring-resteasy/matrixParam;param=matrix</a><br> Or try <a href='http://localhost:8080/spring-resteasy/uriParam/789'>spring-resteasy/uriParam/789</a><br> Or try <a href='http://localhost:8080/spring-resteasy/locating/hello?name=yourname'>spring-resteasy/locating/hello?name=yourname</a><br> Or try <a href='http://localhost:8080/spring-resteasy/locating/basic'>spring-resteasy/locating/basic</a><br> Or try <a href='http://localhost:8080/spring-resteasy/locating/queryParam?param=query'>spring-resteasy/locating/queryParam?param=query</a><br> Or try <a href='http://localhost:8080/spring-resteasy/locating/matrixParam;param=matrix'>spring-resteasy/locating/matrixParam;param=matrix</a><br> Or try <a href='http://localhost:8080/spring-resteasy/locating/uriParam/789'>spring-resteasy/locating/uriParam/789</a>";
        System.out.println("getDefault()");
        return Response.ok((Object)msg).build();
    }

    @GET
    @Path(value="hello")
    @Produces(value={"text/plain"})
    public Response sayHello(@QueryParam(value="name") String name) {
        String greetingMsg = this.greetingBean.greet(name);
        System.out.println("Sending greeing: " + greetingMsg);
        return Response.ok((Object)greetingMsg).build();
    }

    @GET
    @Path(value="basic")
    @Produces(value={"text/plain"})
    public String getBasic() {
        System.out.println("getBasic()");
        return "basic";
    }

    @PUT
    @Path(value="basic")
    @Consumes(value={"text/plain"})
    public void putBasic(String body) {
        System.out.println(body);
    }

    @GET
    @Path(value="queryParam")
    @Produces(value={"text/plain"})
    public String getQueryParam(@QueryParam(value="param") String param) {
        return param;
    }

    @GET
    @Path(value="matrixParam")
    @Produces(value={"text/plain"})
    public String getMatrixParam(@MatrixParam(value="param") String param) {
        return param;
    }

    @GET
    @Path(value="uriParam/{param}")
    @Produces(value={"text/plain"})
    public int getUriParam(@PathParam(value="param") int param) {
        return param;
    }
}

