/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.temperatureconverter.controller;

import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.temperatureconverter.ejb.Scale;
import org.jboss.as.quickstarts.temperatureconverter.ejb.Temperature;
import org.jboss.as.quickstarts.temperatureconverter.ejb.TemperatureConvertEJB;

@Named(value="temperatureConverter")
@RequestScoped
public class TemperatureConverter
implements Serializable {
    @Inject
    private TemperatureConvertEJB temperatureConvertEJB;
    private String temperature;
    private String sourceTemperature = "0.0";
    private Scale defaultScale = Scale.CELSIUS;

    public void convert() {
        try {
            this.temperature = this.temperatureConvertEJB.convert(Temperature.parse((String)this.sourceTemperature, (Scale)this.defaultScale)).toString();
        }
        catch (IllegalArgumentException e) {
            this.temperature = "Invalid temperature";
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(e.getMessage()));
        }
    }

    public String getSourceTemperature() {
        return this.sourceTemperature;
    }

    public void setSourceTemperature(String sourceTemperature) {
        this.sourceTemperature = sourceTemperature;
    }

    public Scale getDefaultScale() {
        return this.defaultScale;
    }

    public void setDefaultScale(Scale defaultScale) {
        this.defaultScale = defaultScale;
    }

    public String getTemperature() {
        return this.temperature;
    }
}

