/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.temperatureconverter.ejb;

public enum Scale {
    CELSIUS("\u2103"),
    FAHRENHEIT("\u2109");

    private final String symbol;

    private Scale(String symbol) {
        this.symbol = symbol;
    }

    public static Scale valueOfAbbreviation(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if ("C".equals(value.toUpperCase())) {
            return CELSIUS;
        }
        if ("F".equals(value.toUpperCase())) {
            return FAHRENHEIT;
        }
        throw new IllegalArgumentException(value + " not recognized as a valid scale");
    }

    public String getSymbol() {
        return this.symbol;
    }
}

