/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.temperatureconverter.ejb;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.quickstarts.temperatureconverter.ejb.Scale;

public class Temperature {
    public static final double ABSOLUTE_ZERO_C = -273.15;
    public static final double ABSOLUTE_ZERO_F = -459.67;
    private static Pattern PATTERN = Pattern.compile("^([-+]?\\d*\\.?\\d+)\\s*([cCfF]?)");
    private final double temperature;
    private final Scale scale;

    public static Temperature parse(String temperature, Scale defaultScale) {
        Scale s;
        double t;
        Matcher matcher = PATTERN.matcher(temperature);
        if (matcher.find()) {
            t = Double.parseDouble(matcher.group(1));
            if (!matcher.group(2).isEmpty()) {
                try {
                    s = Scale.valueOfAbbreviation((String)matcher.group(2));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("You must provide a valid temperature to convert.");
                }
            } else {
                s = defaultScale;
            }
        } else {
            throw new IllegalArgumentException("You must provide a valid temperature to convert.");
        }
        return new Temperature(t, s);
    }

    public Temperature(double temperature, Scale scale) {
        this.temperature = temperature;
        this.scale = scale;
    }

    public Scale getScale() {
        return this.scale;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public String toString() {
        return new DecimalFormat("###.###").format(this.temperature) + " " + this.scale.getSymbol();
    }
}

