/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.threadracing;

import java.io.IOException;
import java.util.List;
import javax.websocket.Session;
import org.jboss.as.quickstarts.threadracing.RaceBroadcaster;
import org.jboss.as.quickstarts.threadracing.results.ChampionshipStandings;
import org.jboss.as.quickstarts.threadracing.results.RaceResult;

public class WebSocketRaceBroadcaster
implements RaceBroadcaster {
    private final Session session;

    public WebSocketRaceBroadcaster(Session session) {
        this.session = session;
    }

    private void sendToClient(String message) {
        try {
            this.session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void pause(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        this.sendToClient("Wow, what a crowd today at Threadianopolis... ");
        this.pause(2000L);
        this.sendToClient("There must be more than a GIGABYTE of thread racing fans going nuts.<br/><br/>");
        this.pause(3000L);
    }

    public void startYourEngines() {
        this.pause(1000L);
        this.sendToClient("<br/>Racers, ");
        this.pause(2000L);
        this.sendToClient("start ");
        this.pause(1000L);
        this.sendToClient("your ");
        this.pause(1000L);
        this.sendToClient("THREADS.<br/>");
    }

    public void readySetGo() {
        this.pause(2000L);
        this.sendToClient("<br/>Ready... ");
        this.pause(2000L);
        this.sendToClient("Set... ");
        this.pause(2000L);
        this.sendToClient("Go! <br/><br/>");
    }

    public void raceProgress(String msg) {
        this.sendToClient(msg + "<br/>");
    }

    public void raceEnd() {
        this.sendToClient("<br/>Please await() the official results ");
        this.pause(2000L);
        this.sendToClient(":");
        this.pause(2000L);
        this.sendToClient("-");
        this.pause(2000L);
        this.sendToClient(")<br/>");
    }

    public void raceResult(RaceResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>Official Race Results</h2>");
        sb.append("<ol>");
        for (String racer : result.getSortedRacers()) {
            sb.append("<li>" + racer + "</li>");
        }
        sb.append("</ol>");
        this.sendToClient(sb.toString());
    }

    public void championshipStandings(List<ChampionshipStandings.Entry> entries) {
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>Championship Standings</h2>");
        sb.append("<ol>");
        for (ChampionshipStandings.Entry entry : entries) {
            sb.append("<li>" + entry.getName() + ", " + entry.getPoints() + " points</li>");
        }
        sb.append("</ol>");
        this.sendToClient(sb.toString());
    }
}

