/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.threadracing.stage.jms;

import java.util.UUID;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import org.jboss.as.quickstarts.threadracing.Race;
import org.jboss.as.quickstarts.threadracing.stage.RaceStage;

public class JMSRaceStage
implements RaceStage {
    @Resource(lookup="java:global/threadRacing/stages/jms/requestQueue")
    private Queue requestQueue;
    @Resource(lookup="java:comp/DefaultJMSConnectionFactory")
    private ConnectionFactory cf;

    public void run(Race.Registration registration) throws Exception {
        try (JMSContext jmsContext = this.cf.createContext();){
            TemporaryQueue responseQueue = jmsContext.createTemporaryQueue();
            String request = UUID.randomUUID().toString();
            jmsContext.createProducer().setJMSReplyTo((Destination)responseQueue).send((Destination)this.requestQueue, request);
            try (JMSConsumer consumer = jmsContext.createConsumer((Destination)responseQueue);){
                String response = (String)consumer.receiveBody(String.class);
                if (response == null) {
                    registration.aborted((Throwable)new IllegalStateException("Message processing timed out"));
                } else if (!response.equals(request)) {
                    registration.aborted((Throwable)new IllegalStateException("Response content does not match the request. Response: " + response + ", request: " + request));
                }
            }
        }
    }
}

