/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.threadracing.results;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.quickstarts.threadracing.results.ChampionshipStandings;
import org.jboss.as.quickstarts.threadracing.results.RaceResult;
import org.jboss.as.quickstarts.threadracing.results.RaceResults;

public class ChampionshipStandings {
    private final Map<String, Integer> racerPointsTotals = new HashMap();

    public ChampionshipStandings addAll(RaceResults raceResults) {
        for (RaceResult raceResult : raceResults.findAll()) {
            this.add(raceResult);
        }
        return this;
    }

    public ChampionshipStandings add(RaceResult raceResult) {
        this.processRacerResult(raceResult.getRacer1Name(), raceResult.getRacer1Position(), this.racerPointsTotals);
        this.processRacerResult(raceResult.getRacer2Name(), raceResult.getRacer2Position(), this.racerPointsTotals);
        this.processRacerResult(raceResult.getRacer3Name(), raceResult.getRacer3Position(), this.racerPointsTotals);
        this.processRacerResult(raceResult.getRacer4Name(), raceResult.getRacer4Position(), this.racerPointsTotals);
        return this;
    }

    private void processRacerResult(String racerName, int racerPosition, Map<String, Integer> racerPointsTotals) {
        int racerPoints = racerPosition == 1 ? 4 : (racerPosition == 2 ? 3 : (racerPosition == 3 ? 2 : 1));
        Integer racerPointsTotal = racerPointsTotals.get(racerName);
        if (racerPointsTotal == null) {
            racerPointsTotals.put(racerName, racerPoints);
        } else {
            racerPointsTotals.put(racerName, racerPoints + racerPointsTotal);
        }
    }

    public List<Entry> getEntryList() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Map.Entry racerPointsTotal : this.racerPointsTotals.entrySet()) {
            String racer = (String)racerPointsTotal.getKey();
            Integer points = (Integer)racerPointsTotal.getValue();
            entries.add(new Entry(racer, points, null));
        }
        Collections.sort(entries);
        return entries;
    }
}

