/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.threadracing.results;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.jboss.as.quickstarts.threadracing.Race;

@Entity
@Table(name="THREAD_RACE_RESULTS")
@NamedQueries(value={@NamedQuery(name="RaceResult.findAll", query="SELECT e FROM RaceResult e")})
public class RaceResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    private int id;
    @Column
    private String racer1Name;
    @Column
    private int racer1Position;
    @Column
    private String racer2Name;
    @Column
    private int racer2Position;
    @Column
    private String racer3Name;
    @Column
    private int racer3Position;
    @Column
    private String racer4Name;
    @Column
    private int racer4Position;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getRacer1Name() {
        return this.racer1Name;
    }

    public void setRacer1Name(String racer1Name) {
        this.racer1Name = racer1Name;
    }

    public int getRacer1Position() {
        return this.racer1Position;
    }

    public void setRacer1Position(int racer1Position) {
        this.racer1Position = racer1Position;
    }

    public String getRacer2Name() {
        return this.racer2Name;
    }

    public void setRacer2Name(String racer2Name) {
        this.racer2Name = racer2Name;
    }

    public int getRacer2Position() {
        return this.racer2Position;
    }

    public void setRacer2Position(int racer2Position) {
        this.racer2Position = racer2Position;
    }

    public String getRacer3Name() {
        return this.racer3Name;
    }

    public void setRacer3Name(String racer3Name) {
        this.racer3Name = racer3Name;
    }

    public int getRacer3Position() {
        return this.racer3Position;
    }

    public void setRacer3Position(int racer3Position) {
        this.racer3Position = racer3Position;
    }

    public String getRacer4Name() {
        return this.racer4Name;
    }

    public void setRacer4Name(String racer4Name) {
        this.racer4Name = racer4Name;
    }

    public int getRacer4Position() {
        return this.racer4Position;
    }

    public void setRacer4Position(int racer4Position) {
        this.racer4Position = racer4Position;
    }

    public void setPosition(Race.Registration registration, int position) {
        switch (registration.getNumber()) {
            case 1: {
                this.setRacer1Name(registration.getRacer().getName());
                this.setRacer1Position(position);
                break;
            }
            case 2: {
                this.setRacer2Name(registration.getRacer().getName());
                this.setRacer2Position(position);
                break;
            }
            case 3: {
                this.setRacer3Name(registration.getRacer().getName());
                this.setRacer3Position(position);
                break;
            }
            case 4: {
                this.setRacer4Name(registration.getRacer().getName());
                this.setRacer4Position(position);
                break;
            }
            default: {
                throw new IllegalStateException("registration number must be 1-4");
            }
        }
    }

    public List<String> getSortedRacers() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getRacerWithPosition(1));
        result.add(this.getRacerWithPosition(2));
        result.add(this.getRacerWithPosition(3));
        result.add(this.getRacerWithPosition(4));
        return result;
    }

    public String getRacerWithPosition(int i) {
        if (this.racer1Position == i) {
            return this.racer1Name;
        }
        if (this.racer2Position == i) {
            return this.racer2Name;
        }
        if (this.racer3Position == i) {
            return this.racer3Name;
        }
        if (this.racer4Position == i) {
            return this.racer4Name;
        }
        return null;
    }
}

