/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.websocket.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.jboss.as.quickstarts.websocket.client.Frontend;
import org.jboss.as.quickstarts.websocket.client.SessionManager;
import org.jboss.as.quickstarts.websocket.client.SessionMessage;
import org.jboss.as.quickstarts.websocket.client.ToBackend;
import org.jboss.as.quickstarts.websocket.client.ToBroadcast;
import org.jboss.as.quickstarts.websocket.client.ToFrontend;

@ApplicationScoped
public class Frontend
extends Endpoint {
    private Logger log = Logger.getLogger(Frontend.class.getName());
    public static final String WEBSOCKET_PATH = "/relay";
    private SessionManager sessionManager = new SessionManager();
    @Inject
    @ToBackend
    private Event<SessionMessage> backendTrigger;

    public void init(@Observes @Initialized(value=ApplicationScoped.class) ServletContext servletContext) {
        if (servletContext == null) {
            this.log.severe(String.format("Failed to deploy frontend endpoint %s: %s", WEBSOCKET_PATH, "ServletContext not available"));
            return;
        }
        ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute("javax.websocket.server.ServerContainer");
        if (serverContainer == null) {
            this.log.severe(String.format("Failed to deploy frontend endpoint %s: %s", WEBSOCKET_PATH, "javax.websocket.server.ServerContainer ServerContainer not available"));
            return;
        }
        ServerEndpointConfig config = ServerEndpointConfig.Builder.create(Frontend.class, (String)WEBSOCKET_PATH).configurator((ServerEndpointConfig.Configurator)new /* Unavailable Anonymous Inner Class!! */).build();
        try {
            serverContainer.addEndpoint(config);
        }
        catch (DeploymentException e) {
            this.log.log(Level.SEVERE, String.format("Failed to deploy frontend endpoint %s: %s", WEBSOCKET_PATH, e.getMessage()), e);
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.addMessageHandler(String.class, (MessageHandler.Whole)new FrontendMessageHandler(this, session));
        this.sessionManager.open(session);
        this.sendMessage(session, String.format("Opened frontend session %s", session.getId()));
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.log.info(String.format("Closed frontend session %s", session.getId()));
        this.sessionManager.close(session.getId());
    }

    public void onError(Session session, Throwable thr) {
        this.log.log(Level.WARNING, String.format("Error from frontend session %s", session.getId()), thr);
    }

    public void sendMessage(@Observes @ToFrontend SessionMessage message) {
        Session session = this.sessionManager.get(message.getSessionId());
        if (session == null) {
            this.log.warning(String.format("Frontend session %s not found", message.getSessionId()));
            return;
        }
        this.sendMessage(session, message.getText());
    }

    public void sendBroadcast(@Observes @ToBroadcast String text) {
        this.log.info(String.format("BROADCAST: %s", text));
        for (Session session : this.sessionManager.getAll()) {
            this.sendMessage(session, String.format("BROADCAST: %s", text));
        }
    }

    public void sendMessage(Session session, String text) {
        session.getAsyncRemote().sendText(text);
    }

    static /* synthetic */ Event access$000(Frontend x0) {
        return x0.backendTrigger;
    }
}

