/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.websocket.client;

import java.util.concurrent.TimeUnit;
import org.jboss.as.quickstarts.websocket.client.ConnectionGate;

public class ConnectionGate {
    private final ReclosableLatch latch;

    public ConnectionGate() {
        this.latch = new ReclosableLatch();
    }

    public ConnectionGate(boolean initiallyConnected) {
        this.latch = new ReclosableLatch(initiallyConnected);
    }

    public void connected() {
        this.latch.open();
    }

    public void disconnected() {
        this.latch.close();
    }

    public void waitForConnection() throws InterruptedException {
        this.latch.await();
    }

    public boolean waitForConnection(long time, TimeUnit unit) throws InterruptedException {
        return this.latch.await(time, unit);
    }

    public boolean isConnected() {
        return this.latch.isOpened();
    }
}

