/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.websocket.client;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.net.ssl.SSLContext;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.jboss.as.quickstarts.websocket.client.Backend;
import org.jboss.as.quickstarts.websocket.client.ConnectionGate;
import org.jboss.as.quickstarts.websocket.client.SessionMessage;
import org.jboss.as.quickstarts.websocket.client.ToBackend;
import org.jboss.as.quickstarts.websocket.client.ToBroadcast;
import org.jboss.as.quickstarts.websocket.client.ToFrontend;

@ApplicationScoped
public class Backend
extends Endpoint
implements MessageHandler.Whole<SessionMessage> {
    private Logger log = Logger.getLogger(Backend.class.getName());
    private String echoServerUrl = "wss://echo.websocket.org";
    @Inject
    @ToFrontend
    private Event<SessionMessage> frontendTrigger;
    @Inject
    @ToBroadcast
    private Event<String> broadcastTrigger;
    private ClientEndpointConfig config;
    private Session session;
    private ConnectionGate connectionGate = new ConnectionGate();

    @PostConstruct
    public void init() {
        ArrayList<Class<SessionMessageEncoder>> encoders = new ArrayList<Class<SessionMessageEncoder>>();
        encoders.add(SessionMessageEncoder.class);
        ArrayList<Class<SessionMessageDecoder>> decoders = new ArrayList<Class<SessionMessageDecoder>>();
        decoders.add(SessionMessageDecoder.class);
        this.config = ClientEndpointConfig.Builder.create().encoders(encoders).decoders(decoders).build();
        try {
            this.config.getUserProperties().put("io.undertow.websocket.SSL_CONTEXT", SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException e) {
            this.log.log(Level.SEVERE, String.format("Failed to deploy backend endpoint: %s", e.getMessage()), e);
        }
        this.connect();
    }

    public void connect() {
        this.broadcastTrigger.fire((Object)String.format("Connecting to backend %s", this.echoServerUrl));
        try {
            ContainerProvider.getWebSocketContainer().connectToServer((Endpoint)this, this.config, URI.create(this.echoServerUrl));
        }
        catch (Exception e) {
            this.broadcastTrigger.fire((Object)String.format("Failed to connect to backend %s: %s", this.echoServerUrl, e.getMessage()));
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        session.addMessageHandler(SessionMessage.class, (MessageHandler.Whole)this);
        this.broadcastTrigger.fire((Object)String.format("Opened backend session %s", session.getId()));
        this.connectionGate.connected();
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.connectionGate.disconnected();
        this.broadcastTrigger.fire((Object)String.format("Closed backend session %s due to %s", session.getId(), closeReason.getReasonPhrase()));
        this.connect();
    }

    public void onError(Session session, Throwable t) {
        this.broadcastTrigger.fire((Object)String.format("Error from backend session %s: %s", session.getId(), t.getMessage()));
    }

    public void onMessage(SessionMessage message) {
        this.frontendTrigger.fire((Object)new SessionMessage(message.getSessionId(), String.format("Received message from backend session %s to frontend session %s ", this.session.getId(), message.getSessionId())));
        this.frontendTrigger.fire((Object)message);
    }

    public void sendMessage(@Observes @ToBackend SessionMessage message) throws Exception {
        this.connectionGate.waitForConnection(5L, TimeUnit.SECONDS);
        if (!this.connectionGate.isConnected()) {
            this.frontendTrigger.fire((Object)new SessionMessage(message.getSessionId(), String.format("Failed to send frontend session %s message: not connected to backend", message.getSessionId())));
            return;
        }
        this.frontendTrigger.fire((Object)new SessionMessage(message.getSessionId(), String.format("Sending message from frontend session %s to backend session %s", message.getSessionId(), this.session.getId())));
        this.session.getBasicRemote().sendObject((Object)message);
    }
}

