/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.quickstarts.websocket;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.jboss.quickstarts.websocket.BiddingEncoder;
import org.jboss.quickstarts.websocket.Message;
import org.jboss.quickstarts.websocket.MessageDecoder;
import org.jboss.quickstarts.websocket.model.Bid;
import org.jboss.quickstarts.websocket.model.Bidding;
import org.jboss.quickstarts.websocket.model.BiddingFactory;

@ServerEndpoint(value="/bidsocket", encoders={BiddingEncoder.class}, decoders={MessageDecoder.class})
public class BidWebSocketEndpoint {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static Set<Session> clients = Collections.synchronizedSet(new HashSet());
    private Runnable intervalNotifier;

    @PostConstruct
    public void startIntervalNotifier() {
        this.logger.info("Starting interval notifier");
        this.intervalNotifier = new /* Unavailable Anonymous Inner Class!! */;
        new Thread(this.intervalNotifier).start();
    }

    @OnOpen
    public void onOpen(Session session) {
        this.logger.info("New websocket session opened: " + session.getId());
        clients.add(session);
    }

    @OnClose
    public void onClose(Session session) {
        this.logger.info("Websoket session closed: " + session.getId());
        clients.remove(session);
    }

    @OnMessage
    public void onMessage(Session session, Message message) throws IOException, EncodeException {
        Bidding bidding;
        if (message.getCommand().equals("newBid")) {
            bidding = BiddingFactory.getBidding();
            bidding.addBid(new Bid(session.getId(), message.getBidValue()));
        }
        if (message.getCommand().equals("buyItNow")) {
            bidding = BiddingFactory.getBidding();
            bidding.buyItNow();
        }
        if (message.getCommand().equals("resetBid")) {
            BiddingFactory.resetBidding();
        }
        this.notifyAllSessions(BiddingFactory.getBidding());
    }

    @OnError
    public void error(Session session, Throwable t) {
        t.printStackTrace();
    }

    private void notifyAllSessions(Bidding bidding) throws EncodeException, IOException {
        for (Session s : clients) {
            s.getBasicRemote().sendObject((Object)bidding);
        }
    }

    static /* synthetic */ void access$000(BidWebSocketEndpoint x0, Bidding x1) throws EncodeException, IOException {
        x0.notifyAllSessions(x1);
    }
}

