/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.quickstarts.websocket;

import java.io.StringWriter;
import java.io.Writer;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;
import org.jboss.quickstarts.websocket.model.Bid;
import org.jboss.quickstarts.websocket.model.Bidding;

public class BiddingEncoder
implements Encoder.Text<Bidding> {
    public void destroy() {
    }

    public void init(EndpointConfig config) {
    }

    public String encode(Bidding bidding) throws EncodeException {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder().add("item", (JsonValue)Json.createObjectBuilder().add("buyNowPrice", bidding.getItem().getBuyNowPrice().intValue()).add("description", bidding.getItem().getDescription()).add("imagePath", bidding.getItem().getImagePath()).add("title", bidding.getItem().getTitle()).build()).add("bidStatus", bidding.getBidStatus().toString()).add("currentPrice", bidding.getCurrentPrice().intValue()).add("secondsLeft", 0);
        if (bidding.getDueDate() != null) {
            jsonBuilder.add("dueDate", bidding.getDueDate().getTime());
        }
        if (bidding.getSecondsLeft() != null) {
            jsonBuilder.add("secondsLeft", bidding.getSecondsLeft().intValue());
        }
        JsonArrayBuilder jsonBidArray = Json.createArrayBuilder();
        for (Bid bid : bidding.getBids()) {
            jsonBidArray.add((JsonValue)Json.createObjectBuilder().add("dateTime", bid.getDateTime().getTime()).add("value", bid.getValue().intValue()).add("id", bid.getId()).build());
        }
        jsonBuilder.add("bids", jsonBidArray);
        StringWriter stWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stWriter);
        jsonWriter.writeObject(jsonBuilder.build());
        jsonWriter.close();
        return stWriter.toString();
    }
}

