/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.quickstarts.websocket.model;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.quickstarts.websocket.model.Bid;
import org.jboss.quickstarts.websocket.model.BidStatus;
import org.jboss.quickstarts.websocket.model.Item;

public class Bidding {
    static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private Item item = null;
    private BidStatus bidStatus = BidStatus.NOT_STARTED;
    private Date dueDate = null;
    private Integer currentPrice = null;
    private Integer secondsLeft = null;
    private Set<Bid> bids = new TreeSet(new /* Unavailable Anonymous Inner Class!! */);

    public Bidding(Item item, Integer currentPrice) {
        this.item = item;
        this.currentPrice = currentPrice;
    }

    public BidStatus getBidStatus() {
        return this.bidStatus;
    }

    public Item getItem() {
        return this.item;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Set<Bid> getBids() {
        return this.bids;
    }

    public void addBid(Bid bid) {
        this.getBids().add(bid);
        if (!this.bidStatus.equals((Object)BidStatus.SOLD) || !this.bidStatus.equals((Object)BidStatus.EXPIRED)) {
            this.currentPrice = this.getCurrentPrice() + bid.getValue();
        }
        if (this.getBidStatus().equals((Object)BidStatus.NOT_STARTED)) {
            this.bidStatus = BidStatus.STARTED;
            long now = new Date().getTime();
            this.dueDate = new Date(now + 60000L);
        }
        if (this.getCurrentPrice() > this.getItem().getBuyNowPrice()) {
            this.bidStatus = BidStatus.SOLD;
        }
    }

    public void expire() {
        this.bidStatus = BidStatus.EXPIRED;
    }

    public Integer getCurrentPrice() {
        return this.currentPrice;
    }

    public void buyItNow() {
        if (this.getBidStatus().equals((Object)BidStatus.STARTED) || this.getBidStatus().equals((Object)BidStatus.NOT_STARTED)) {
            this.bidStatus = BidStatus.SOLD;
            this.currentPrice = this.item.getBuyNowPrice();
        }
    }

    public Integer getSecondsLeft() {
        if (this.getBidStatus().equals((Object)BidStatus.STARTED)) {
            GregorianCalendar now = new GregorianCalendar();
            this.secondsLeft = (int)((this.getDueDate().getTime() - now.getTime().getTime()) / 1000L);
            return this.secondsLeft;
        }
        return null;
    }
}

