/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.wsat.simple;

import java.util.concurrent.atomic.AtomicInteger;

public class MockRestaurantManager {
    private static MockRestaurantManager singletonInstance;
    private AtomicInteger bookings = new AtomicInteger(0);

    public static synchronized MockRestaurantManager getSingletonInstance() {
        if (singletonInstance == null) {
            singletonInstance = new MockRestaurantManager();
        }
        return singletonInstance;
    }

    public synchronized void makeBooking(Object txID) {
        System.out.println("[SERVICE] makeBooking called on backend resource.");
    }

    public boolean prepare(Object txID) {
        System.out.println("[SERVICE] prepare called on backend resource.");
        return true;
    }

    public void commit(Object txID) {
        System.out.println("[SERVICE] commit called on backend resource.");
        this.bookings.getAndIncrement();
    }

    public void rollback(Object txID) {
        System.out.println("[SERVICE] rollback called on backend resource.");
    }

    public int getBookingCount() {
        return this.bookings.get();
    }

    public void reset() {
        this.bookings.set(0);
    }
}

