/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.wsat.simple;

import com.arjuna.wst.Aborted;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.Prepared;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.Vote;
import com.arjuna.wst.WrongStateException;
import java.io.Serializable;
import org.jboss.as.quickstarts.wsat.simple.MockRestaurantManager;

public class RestaurantParticipant
implements Durable2PCParticipant,
Serializable {
    private static final long serialVersionUID = 1L;
    private MockRestaurantManager mockRestaurantManager = MockRestaurantManager.getSingletonInstance();
    private String txID;

    public RestaurantParticipant(String txID) {
        this.txID = txID;
    }

    public Vote prepare() throws WrongStateException, SystemException {
        System.out.println("[SERVICE] Prepare called on participant, about to prepare the back-end resource");
        boolean success = this.mockRestaurantManager.prepare((Object)this.txID);
        if (success) {
            System.out.println("[SERVICE] back-end resource prepared, participant votes prepared");
            return new Prepared();
        }
        System.out.println("[SERVICE] back-end resource failed to prepare, participant votes aborted");
        return new Aborted();
    }

    public void commit() throws WrongStateException, SystemException {
        System.out.println("[SERVICE] all participants voted 'prepared', so coordinator tells the participant to commit");
        this.mockRestaurantManager.commit((Object)this.txID);
    }

    public void rollback() throws WrongStateException, SystemException {
        System.out.println("[SERVICE] one or more participants voted 'aborted' or a failure occurred, so coordinator tells the participant to rollback");
        this.mockRestaurantManager.rollback((Object)this.txID);
    }

    public void unknown() throws SystemException {
        System.out.println("RestaurantParticipantAT.unknown");
    }

    public void error() throws SystemException {
        System.out.println("RestaurantParticipantAT.error");
    }
}

