/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.wsat.simple.servlet;

import com.arjuna.mw.wst11.UserTransaction;
import com.arjuna.mw.wst11.UserTransactionFactory;
import com.arjuna.mw.wst11.client.JaxWSHeaderContextProcessor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceRef;
import org.jboss.as.quickstarts.wsat.simple.jaxws.RestaurantServiceAT;
import org.jboss.as.quickstarts.wsat.simple.jaxws.RestaurantServiceATService;

@WebServlet(value={"/WSATSimpleServletClient"})
public class WSATSimpleServletClient
extends HttpServlet {
    private static final long serialVersionUID = -8314035702649252239L;
    @WebServiceRef(value=RestaurantServiceATService.class)
    private RestaurantServiceAT client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BindingProvider bindingProvider = (BindingProvider)this.client;
        ArrayList<JaxWSHeaderContextProcessor> handlers = new ArrayList<JaxWSHeaderContextProcessor>(1);
        handlers.add(new JaxWSHeaderContextProcessor());
        bindingProvider.getBinding().setHandlerChain(handlers);
        String openshift = System.getenv("OPENSHIFT_APP_DNS");
        if (openshift != null) {
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://" + openshift + "/RestaurantServiceAT");
        }
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        out.write("<h1>Quickstart: This example demonstrates the deployment of a WS-AT (WS-AtomicTransaction) enabled JAX-WS Web service bundled in a war archive for deployment to *Red Hat JBoss Enterprise Application Platform*.</h1>");
        System.out.println("[CLIENT] Creating a new WS-AT User Transaction");
        UserTransaction ut = UserTransactionFactory.userTransaction();
        try {
            System.out.println("[CLIENT] Beginning Atomic Transaction (All calls to Web services that support WS-AT wil be included in this transaction)");
            ut.begin();
            System.out.println("[CLIENT] invoking makeBooking() on WS");
            this.client.makeBooking();
            System.out.println("[CLIENT] committing Atomic Transaction (This will cause the AT to complete successfully)");
            ut.commit();
            out.write("<p><b>Transaction succeeded!</b></p>");
        }
        catch (Exception e) {
            e.printStackTrace();
            out.write("<p><b>Transaction failed with the following error:</b></p>");
            out.write("<p><blockquote>");
            out.write(e.toString());
            out.write("</blockquote></p>");
        }
        finally {
            this.rollbackIfActive(ut);
            this.client.reset();
            out.write("<p><i>Go to your JBoss EAP Server console or log to see the detailed result of the transaction.</i></p>");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void rollbackIfActive(UserTransaction ut) {
        try {
            ut.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

