/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.wsat.simple;

import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.mw.wst11.UserTransactionFactory;
import com.arjuna.wst.Durable2PCParticipant;
import java.util.UUID;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.servlet.annotation.WebServlet;
import org.jboss.as.quickstarts.wsat.simple.MockRestaurantManager;
import org.jboss.as.quickstarts.wsat.simple.RestaurantException;
import org.jboss.as.quickstarts.wsat.simple.RestaurantParticipant;
import org.jboss.as.quickstarts.wsat.simple.jaxws.RestaurantServiceAT;

@WebService(serviceName="RestaurantServiceATService", portName="RestaurantServiceAT", name="RestaurantServiceAT", targetNamespace="http://www.jboss.org/jboss-jdf/jboss-as-quickstart/wsat/simple/Restaurant")
@HandlerChain(file="/context-handlers.xml", name="Context Handlers")
@SOAPBinding(style=SOAPBinding.Style.RPC)
@WebServlet(value={"/RestaurantServiceAT"})
public class RestaurantServiceATImpl
implements RestaurantServiceAT {
    private MockRestaurantManager mockRestaurantManager = MockRestaurantManager.getSingletonInstance();

    @WebMethod
    public void makeBooking() throws RestaurantException {
        String transactionId;
        System.out.println("[SERVICE] Restaurant service invoked to make a booking");
        try {
            transactionId = UserTransactionFactory.userTransaction().toString();
            RestaurantParticipant restaurantParticipant = new RestaurantParticipant(transactionId);
            TransactionManager transactionManager = TransactionManagerFactory.transactionManager();
            System.out.println("[SERVICE] Enlisting a Durable2PC participant into the AT");
            transactionManager.enlistForDurableTwoPhase((Durable2PCParticipant)restaurantParticipant, "restaurantServiceAT:" + UUID.randomUUID());
        }
        catch (Exception e) {
            throw new RestaurantException("Error when enlisting participant", (Throwable)e);
        }
        System.out.println("[SERVICE] Invoking the back-end business logic");
        this.mockRestaurantManager.makeBooking((Object)transactionId);
    }

    public int getBookingCount() {
        return this.mockRestaurantManager.getBookingCount();
    }

    public void reset() {
        this.mockRestaurantManager.reset();
    }
}

