/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstart.xml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.jboss.as.quickstart.xml.Book;
import org.jboss.as.quickstart.xml.Errors;
import org.jboss.as.quickstart.xml.XMLParser;
import org.xml.sax.ErrorHandler;

@RequestScoped
@Default
public class DOM4JXMLParser
extends XMLParser {
    @Inject
    private Errors errorHolder;
    private SAXReader dom4jReader = new SAXReader();
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");

    DOM4JXMLParser() throws Exception {
        this.dom4jReader.setErrorHandler((ErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<Book> parseInternal(InputStream is) throws Exception {
        Document document = this.dom4jReader.read(is);
        ArrayList<Book> catalog = new ArrayList<Book>();
        Element root = document.getRootElement();
        if (!root.getQName().getName().equals("catalog")) {
            throw new RuntimeException("Wrong element: " + root.getQName());
        }
        Iterator children = root.elementIterator();
        while (children.hasNext()) {
            Node n = (Node)children.next();
            String childName = n.getName();
            if (childName == null || !childName.equals("book")) continue;
            Book b = this.parseBook((Element)n);
            catalog.add(b);
        }
        return catalog;
    }

    private Book parseBook(Element n) {
        Book b = new Book();
        Iterator children = n.elementIterator();
        while (children.hasNext()) {
            String textVal;
            Element childElement;
            Node child = (Node)children.next();
            String childName = child.getName();
            if (childName == null) continue;
            if (childName.equals("author")) {
                childElement = (Element)child;
                textVal = childElement.getTextTrim();
                b.setAuthor(textVal);
                continue;
            }
            if (childName.equals("title")) {
                childElement = (Element)child;
                textVal = childElement.getTextTrim();
                b.setTitle(textVal);
                continue;
            }
            if (childName.equals("genre")) {
                childElement = (Element)child;
                textVal = childElement.getTextTrim();
                b.setGenre(textVal);
                continue;
            }
            if (childName.equals("price")) {
                childElement = (Element)child;
                textVal = childElement.getTextTrim();
                b.setPrice(Float.parseFloat(textVal));
                continue;
            }
            if (childName.equals("publish_date")) {
                childElement = (Element)child;
                textVal = childElement.getTextTrim();
                try {
                    Date d = DATE_FORMATTER.parse(textVal);
                    b.setPublishDate(d);
                    continue;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!childName.equals("description")) continue;
            childElement = (Element)child;
            textVal = childElement.getTextTrim();
            b.setDescription(textVal);
        }
        return b;
    }

    static /* synthetic */ Errors access$000(DOM4JXMLParser x0) {
        return x0.errorHolder;
    }
}

