/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.encryption.SecretKeyUtil;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public class ExternalKeyStoreCredentialStoreTest {
    private static final String KEY_KEY_STORE_NAME = "secret.pkcs12";
    private static final String SECRET_KEY_ALIAS = "secret";
    private final char[] keyStorePassword = "The quick brown fox jumped over the lazy dog".toCharArray();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File keyKeyStoreFile;
    private PasswordFactory passwordFactory;
    private String providerName;
    private char[] secretPassword;
    private PasswordCredential storedPasswordCredential;
    private SecretKeyCredential storedSecretKeyCredential;
    private CredentialStore.CredentialSourceProtectionParameter storeProtection;

    @Before
    public void prepareTest() throws Exception {
        byte[] rawKey = new byte[16];
        Arrays.fill(rawKey, (byte)0);
        SecretKeySpec secretKey = new SecretKeySpec(rawKey, "AES");
        KeyStore keyKeyStore = KeyStore.getInstance("PKCS12");
        KeyStore.PasswordProtection keyStoreProtection = new KeyStore.PasswordProtection(this.keyStorePassword);
        keyKeyStore.load(null, this.keyStorePassword);
        keyKeyStore.setEntry(SECRET_KEY_ALIAS, new KeyStore.SecretKeyEntry(secretKey), keyStoreProtection);
        this.keyKeyStoreFile = this.temporaryFolder.newFile(KEY_KEY_STORE_NAME);
        try (FileOutputStream fos = new FileOutputStream(this.keyKeyStoreFile);){
            keyKeyStore.store(fos, this.keyStorePassword);
        }
        WildFlyElytronPasswordProvider provider = WildFlyElytronPasswordProvider.getInstance();
        this.providerName = provider.getName();
        Security.addProvider((Provider)provider);
        this.passwordFactory = PasswordFactory.getInstance((String)"clear");
        Password password = this.passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(this.keyStorePassword));
        PasswordCredential credential = new PasswordCredential(password);
        IdentityCredentials credentialSource = IdentityCredentials.NONE.withCredential((Credential)credential);
        this.storeProtection = new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)credentialSource);
        this.secretPassword = "this is a password".toCharArray();
        Password secret = this.passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(this.secretPassword));
        this.storedPasswordCredential = new PasswordCredential(secret);
        this.storedSecretKeyCredential = new SecretKeyCredential(SecretKeyUtil.generateSecretKey((int)256));
    }

    @After
    public void removeWildFlyElytronProvider() {
        Security.removeProvider(this.providerName);
    }

    private CredentialStoreSpi getCredentialStore(File location) throws Exception {
        KeyStoreCredentialStore keyStoreCredentialStore = new KeyStoreCredentialStore();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("keyStoreType", "PKCS12");
        attributes.put("keyAlias", SECRET_KEY_ALIAS);
        attributes.put("create", Boolean.TRUE.toString());
        attributes.put("location", this.keyKeyStoreFile.getAbsolutePath());
        attributes.put("external", Boolean.TRUE.toString());
        attributes.put("externalPath", location.getAbsolutePath());
        keyStoreCredentialStore.initialize(attributes, (CredentialStore.ProtectionParameter)this.storeProtection, null);
        return keyStoreCredentialStore;
    }

    @Test
    public void testPasswordCredential() throws Exception {
        File credentialStoreFile = new File(this.temporaryFolder.getRoot(), "test.credential.store");
        CredentialStoreSpi credentialStore = this.getCredentialStore(credentialStoreFile);
        credentialStore.store("testAlias", (Credential)this.storedPasswordCredential, null);
        credentialStore.flush();
        Assert.assertTrue((String)"Credential Store File Created", (boolean)credentialStoreFile.exists());
        credentialStore = this.getCredentialStore(credentialStoreFile);
        PasswordCredential retrievedCredential = (PasswordCredential)credentialStore.retrieve("testAlias", PasswordCredential.class, null, null, null);
        ClearPasswordSpec retrievedPassword = (ClearPasswordSpec)this.passwordFactory.getKeySpec(retrievedCredential.getPassword(), ClearPasswordSpec.class);
        Assert.assertArrayEquals((char[])this.secretPassword, (char[])retrievedPassword.getEncodedPassword());
    }

    @Test
    public void testSecretKeyCredential() throws Exception {
        File credentialStoreFile = new File(this.temporaryFolder.getRoot(), "test.credential.store");
        CredentialStoreSpi credentialStore = this.getCredentialStore(credentialStoreFile);
        credentialStore.store("testAlias", (Credential)this.storedSecretKeyCredential, null);
        credentialStore.flush();
        Assert.assertTrue((String)"Credential Store File Created", (boolean)credentialStoreFile.exists());
        credentialStore = this.getCredentialStore(credentialStoreFile);
        SecretKeyCredential retrievedSecretKeyCredential = (SecretKeyCredential)credentialStore.retrieve("testAlias", SecretKeyCredential.class, null, null, null);
        Assert.assertEquals((String)"Expect SecretKeys to match", (Object)this.storedSecretKeyCredential.getSecretKey(), (Object)retrievedSecretKeyCredential.getSecretKey());
    }

    @Test
    public void testBothCredentials() throws Exception {
        File credentialStoreFile = new File(this.temporaryFolder.getRoot(), "test.credential.store");
        CredentialStoreSpi credentialStore = this.getCredentialStore(credentialStoreFile);
        credentialStore.store("testAlias", (Credential)this.storedPasswordCredential, null);
        credentialStore.store("testAlias", (Credential)this.storedSecretKeyCredential, null);
        credentialStore.flush();
        Assert.assertTrue((String)"Credential Store File Created", (boolean)credentialStoreFile.exists());
        credentialStore = this.getCredentialStore(credentialStoreFile);
        Set aliases = credentialStore.getAliases();
        Assert.assertEquals((String)"Expected alias count", (long)1L, (long)aliases.size());
        Assert.assertTrue((String)"Expected alias 'testAlias'", (boolean)aliases.contains("testalias"));
        PasswordCredential retrievedCredential = (PasswordCredential)credentialStore.retrieve("testAlias", PasswordCredential.class, null, null, null);
        ClearPasswordSpec retrievedPassword = (ClearPasswordSpec)this.passwordFactory.getKeySpec(retrievedCredential.getPassword(), ClearPasswordSpec.class);
        Assert.assertArrayEquals((char[])this.secretPassword, (char[])retrievedPassword.getEncodedPassword());
        SecretKeyCredential retrievedSecretKeyCredential = (SecretKeyCredential)credentialStore.retrieve("testAlias", SecretKeyCredential.class, null, null, null);
        Assert.assertEquals((String)"Expect SecretKeys to match", (Object)this.storedSecretKeyCredential.getSecretKey(), (Object)retrievedSecretKeyCredential.getSecretKey());
    }
}

