/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.SecretKey;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.WildFlyElytronCredentialStoreProvider;
import org.wildfly.security.encryption.SecretKeyUtil;

public class PropertiesCredentialStoreTest {
    private static final String CREATE = "create";
    private static final String LOCATION = "location";
    private static final String STORE_TYPE = "PropertiesCredentialStore";
    private static final Provider PROVIDER = new WildFlyElytronCredentialStoreProvider();
    private static final Random RANDOM = new Random();
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void testEmptyStore() throws Exception {
        File storeFile = new File(this.getStoragePathForNewFile());
        Assert.assertFalse((boolean)storeFile.exists());
        try {
            CredentialStore credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), true));
            Assert.assertTrue((boolean)storeFile.exists());
            Assert.assertEquals((String)"Alias Count", (long)0L, (long)credentialStore.getAliases().size());
            credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), false));
            Assert.assertEquals((String)"Alias Count", (long)0L, (long)credentialStore.getAliases().size());
        }
        finally {
            if (storeFile.exists()) {
                storeFile.delete();
            }
        }
    }

    @Test
    public void testCreatingStoreWithParentDirectories() throws Exception {
        File storeFile = new File(this.tmp.getRoot().getAbsolutePath() + "/parent1/parent2/test1.store");
        Assert.assertFalse((boolean)storeFile.exists());
        try {
            CredentialStore credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), true));
            Assert.assertTrue((boolean)storeFile.exists());
        }
        finally {
            if (storeFile.exists()) {
                storeFile.delete();
            }
        }
    }

    @Test
    public void testFileDoesNotExist() throws NoSuchAlgorithmException {
        File storeFile = new File(this.getStoragePathForNewFile());
        Assert.assertFalse((boolean)storeFile.exists());
        try {
            CredentialStore credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), false));
            Assert.fail((String)"Expected Exception Not Thrown");
        }
        catch (CredentialStoreException e) {
            Assert.assertFalse((boolean)storeFile.exists());
            Assert.assertTrue((String)"Expected Error Code", (boolean)e.getMessage().contains("ELY09518"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleSecretKeyEntry() throws Exception {
        SecretKey secretKey128 = SecretKeyUtil.generateSecretKey((int)128);
        File storeFile = new File(this.getStoragePathForNewFile());
        Assert.assertFalse((boolean)storeFile.exists());
        try {
            CredentialStore credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), true));
            Assert.assertTrue((boolean)storeFile.exists());
            Assert.assertEquals((String)"Alias Count", (long)0L, (long)credentialStore.getAliases().size());
            credentialStore.store("mySecretKey", (Credential)new SecretKeyCredential(secretKey128));
            Assert.assertEquals((String)"Alias Count", (long)1L, (long)credentialStore.getAliases().size());
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("mysecretkey"));
            Assert.assertEquals((String)"Returned key", (Object)secretKey128, (Object)((SecretKeyCredential)credentialStore.retrieve("mySecretKey", SecretKeyCredential.class)).getSecretKey());
            credentialStore.flush();
            credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), false));
            Assert.assertEquals((String)"Alias Count", (long)1L, (long)credentialStore.getAliases().size());
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("mysecretkey"));
            Assert.assertEquals((String)"Returned key", (Object)secretKey128, (Object)((SecretKeyCredential)credentialStore.retrieve("mySecretKey", SecretKeyCredential.class)).getSecretKey());
            credentialStore.remove("mySecretKey", SecretKeyCredential.class);
            Assert.assertEquals((String)"Alias Count", (long)0L, (long)credentialStore.getAliases().size());
            credentialStore.flush();
            credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), false));
            Assert.assertEquals((String)"Alias Count", (long)0L, (long)credentialStore.getAliases().size());
        }
        finally {
            if (storeFile.exists()) {
                storeFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreeSecretKeyEntries() throws Exception {
        SecretKey secretKey128 = SecretKeyUtil.generateSecretKey((int)128);
        SecretKey secretKey192 = SecretKeyUtil.generateSecretKey((int)192);
        SecretKey secretKey256 = SecretKeyUtil.generateSecretKey((int)256);
        File storeFile = new File(this.getStoragePathForNewFile());
        Assert.assertFalse((boolean)storeFile.exists());
        try {
            CredentialStore credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), true));
            Assert.assertTrue((boolean)storeFile.exists());
            Assert.assertEquals((String)"Alias Count", (long)0L, (long)credentialStore.getAliases().size());
            credentialStore.store("OneTwoEight", (Credential)new SecretKeyCredential(secretKey128));
            credentialStore.store("OneNineTwo", (Credential)new SecretKeyCredential(secretKey192));
            credentialStore.store("TwoFiveSix", (Credential)new SecretKeyCredential(secretKey256));
            Assert.assertEquals((String)"Alias Count", (long)3L, (long)credentialStore.getAliases().size());
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("onetwoeight"));
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("oneninetwo"));
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("twofivesix"));
            Assert.assertEquals((String)"Returned key", (Object)secretKey128, (Object)((SecretKeyCredential)credentialStore.retrieve("OneTwoEight", SecretKeyCredential.class)).getSecretKey());
            Assert.assertEquals((String)"Returned key", (Object)secretKey192, (Object)((SecretKeyCredential)credentialStore.retrieve("OneNineTwo", SecretKeyCredential.class)).getSecretKey());
            Assert.assertEquals((String)"Returned key", (Object)secretKey256, (Object)((SecretKeyCredential)credentialStore.retrieve("TwoFiveSix", SecretKeyCredential.class)).getSecretKey());
            credentialStore.flush();
            credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), false));
            Assert.assertEquals((String)"Alias Count", (long)3L, (long)credentialStore.getAliases().size());
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("onetwoeight"));
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("oneninetwo"));
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("twofivesix"));
            Assert.assertEquals((String)"Returned key", (Object)secretKey128, (Object)((SecretKeyCredential)credentialStore.retrieve("OneTwoEight", SecretKeyCredential.class)).getSecretKey());
            Assert.assertEquals((String)"Returned key", (Object)secretKey192, (Object)((SecretKeyCredential)credentialStore.retrieve("OneNineTwo", SecretKeyCredential.class)).getSecretKey());
            Assert.assertEquals((String)"Returned key", (Object)secretKey256, (Object)((SecretKeyCredential)credentialStore.retrieve("TwoFiveSix", SecretKeyCredential.class)).getSecretKey());
            credentialStore.remove("OneNineTwo", SecretKeyCredential.class);
            Assert.assertEquals((String)"Alias Count", (long)2L, (long)credentialStore.getAliases().size());
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("onetwoeight"));
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("twofivesix"));
            Assert.assertEquals((String)"Returned key", (Object)secretKey128, (Object)((SecretKeyCredential)credentialStore.retrieve("OneTwoEight", SecretKeyCredential.class)).getSecretKey());
            Assert.assertEquals((String)"Returned key", (Object)secretKey256, (Object)((SecretKeyCredential)credentialStore.retrieve("TwoFiveSix", SecretKeyCredential.class)).getSecretKey());
            credentialStore.flush();
            credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
            credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), false));
            Assert.assertEquals((String)"Alias Count", (long)2L, (long)credentialStore.getAliases().size());
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("onetwoeight"));
            Assert.assertTrue((String)"Correct Alias", (boolean)credentialStore.getAliases().contains("twofivesix"));
            Assert.assertEquals((String)"Returned key", (Object)secretKey128, (Object)((SecretKeyCredential)credentialStore.retrieve("OneTwoEight", SecretKeyCredential.class)).getSecretKey());
            Assert.assertEquals((String)"Returned key", (Object)secretKey256, (Object)((SecretKeyCredential)credentialStore.retrieve("TwoFiveSix", SecretKeyCredential.class)).getSecretKey());
        }
        finally {
            if (storeFile.exists()) {
                storeFile.delete();
            }
        }
    }

    @Test
    public void testMissingPropertyDelimiter() throws IOException, GeneralSecurityException {
        this.testMissingPropertyDelimiter(128);
        this.testMissingPropertyDelimiter(192);
        this.testMissingPropertyDelimiter(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMissingPropertyDelimiter(int keySize) throws IOException, GeneralSecurityException {
        SecretKey secretKey = SecretKeyUtil.generateSecretKey((int)keySize);
        File storeFile = new File(this.getStoragePathForNewFile());
        Assert.assertFalse((boolean)storeFile.exists());
        try {
            try (PrintWriter pw = new PrintWriter(storeFile);){
                pw.print("testAlias");
                pw.println(SecretKeyUtil.exportSecretKey((SecretKey)secretKey));
            }
            try {
                CredentialStore credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
                credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), false));
                Assert.fail((String)"Expected CredentialStoreException Not Thrown");
            }
            catch (CredentialStoreException e) {
                Assert.assertTrue((String)"Expected error", (boolean)e.getMessage().contains("ELY20003:"));
            }
        }
        finally {
            if (storeFile.exists()) {
                storeFile.delete();
            }
        }
    }

    @Test
    public void testTruncatedBase64Value() throws IOException, GeneralSecurityException {
        this.testTruncatedBase64Value(128);
        this.testTruncatedBase64Value(192);
        this.testTruncatedBase64Value(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTruncatedBase64Value(int keySize) throws IOException, GeneralSecurityException {
        SecretKey secretKey = SecretKeyUtil.generateSecretKey((int)keySize);
        File storeFile = new File(this.getStoragePathForNewFile());
        Assert.assertFalse((boolean)storeFile.exists());
        try {
            try (PrintWriter pw = new PrintWriter(storeFile);){
                pw.print("testAlias=");
                String secretKeyToken = SecretKeyUtil.exportSecretKey((SecretKey)secretKey);
                pw.println(secretKeyToken.subSequence(0, secretKeyToken.length() - 1));
            }
            try {
                CredentialStore credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
                credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), false));
                Assert.fail((String)"Expected CredentialStoreException Not Thrown");
            }
            catch (CredentialStoreException e) {
                Assert.assertTrue((String)"Expected error", (boolean)e.getMessage().contains("ELY20004:"));
                String causeMessage = e.getCause().getMessage();
                Assert.assertTrue((String)"Expected cause", (boolean)causeMessage.contains("ELY19004:"));
            }
        }
        finally {
            if (storeFile.exists()) {
                storeFile.delete();
            }
        }
    }

    @Test
    public void testTruncatedKey() throws IOException, GeneralSecurityException {
        this.testTruncatedKey(128);
        this.testTruncatedKey(192);
        this.testTruncatedKey(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTruncatedKey(int keySize) throws IOException, GeneralSecurityException {
        SecretKey secretKey = SecretKeyUtil.generateSecretKey((int)keySize);
        File storeFile = new File(this.getStoragePathForNewFile());
        Assert.assertFalse((boolean)storeFile.exists());
        try {
            try (PrintWriter pw = new PrintWriter(storeFile);){
                pw.print("testAlias=");
                byte[] underlyingToken = CodePointIterator.ofString((String)SecretKeyUtil.exportSecretKey((SecretKey)secretKey)).base64Decode().drain();
                String secretKeyToken = ByteIterator.ofBytes((byte[])underlyingToken, (int)0, (int)(underlyingToken.length - 2)).base64Encode().drainToString();
                pw.println(secretKeyToken);
            }
            try {
                CredentialStore credentialStore = CredentialStore.getInstance((String)STORE_TYPE, () -> new Provider[]{PROVIDER});
                credentialStore.initialize(PropertiesCredentialStoreTest.toConfigurationMap(storeFile.getAbsolutePath(), false));
                Assert.fail((String)"Expected CredentialStoreException Not Thrown");
            }
            catch (CredentialStoreException e) {
                Assert.assertTrue((String)"Expected error", (boolean)e.getMessage().contains("ELY20004:"));
                String causeMessage = e.getCause().getMessage();
                Assert.assertTrue((String)"Expected cause", (boolean)causeMessage.contains("ELY19000:"));
            }
        }
        finally {
            if (storeFile.exists()) {
                storeFile.delete();
            }
        }
    }

    private static Map<String, String> toConfigurationMap(String location, boolean create) {
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        if (location != null) {
            configurationMap.put(LOCATION, location);
        }
        if (create) {
            configurationMap.put(CREATE, Boolean.TRUE.toString());
        }
        return Collections.unmodifiableMap(configurationMap);
    }

    private String getStoragePathForNewFile() {
        Path path;
        while (Files.exists(path = Paths.get(this.tmp.getRoot().getAbsolutePath(), "/test_" + RANDOM.nextInt() + ".store"), new LinkOption[0])) {
        }
        return path.toAbsolutePath().toString();
    }
}

