/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.encryption.SecretKeyUtil;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.ClearPasswordSpec;

@RunWith(value=Parameterized.class)
public class KeyStoreCredentialStoreTest {
    @Parameterized.Parameter
    public String keyStoreFormat;
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private final char[] keyStorePassword = "The quick brown fox jumped over the lazy dog".toCharArray();
    private PasswordFactory passwordFactory;
    private String providerName;
    private char[] secretPassword;
    private PasswordCredential storedPasswordCredential;
    private SecretKeyCredential storedSecretKeyCredential;
    private CredentialStore.CredentialSourceProtectionParameter storeProtection;

    @Parameterized.Parameters(name="format={0}")
    public static Iterable<Object[]> keystoreFormats() {
        String vendor = System.getProperty("java.vendor");
        if (vendor.contains("IBM") || vendor.toLowerCase().contains("hewlett")) {
            return Collections.singletonList(new Object[]{"JCEKS"});
        }
        return Arrays.asList({"JCEKS"}, {"PKCS12"});
    }

    @Before
    public void installWildFlyElytronProvider() throws Exception {
        WildFlyElytronPasswordProvider provider = WildFlyElytronPasswordProvider.getInstance();
        this.providerName = provider.getName();
        Security.addProvider((Provider)provider);
        this.passwordFactory = PasswordFactory.getInstance((String)"clear");
        Password password = this.passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(this.keyStorePassword));
        PasswordCredential credential = new PasswordCredential(password);
        IdentityCredentials credentialSource = IdentityCredentials.NONE.withCredential((Credential)credential);
        this.storeProtection = new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)credentialSource);
        this.secretPassword = "this is a password".toCharArray();
        Password secret = this.passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(this.secretPassword));
        this.storedPasswordCredential = new PasswordCredential(secret);
        this.storedSecretKeyCredential = new SecretKeyCredential(SecretKeyUtil.generateSecretKey((int)256));
    }

    @After
    public void removeWildFlyElytronProvider() {
        Security.removeProvider(this.providerName);
    }

    @Test
    public void shouldSupportKeyStoreFormat() throws Exception {
        KeyStoreCredentialStore originalStore = new KeyStoreCredentialStore();
        File keyStoreFile = new File(this.tmp.getRoot(), "keystore");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("location", keyStoreFile.getAbsolutePath());
        attributes.put("create", Boolean.TRUE.toString());
        attributes.put("keyStoreType", this.keyStoreFormat);
        originalStore.initialize(attributes, (CredentialStore.ProtectionParameter)this.storeProtection, null);
        originalStore.store("key", (Credential)this.storedPasswordCredential, null);
        originalStore.flush();
        Assert.assertTrue((boolean)keyStoreFile.exists());
        KeyStoreCredentialStore retrievalStore = new KeyStoreCredentialStore();
        attributes.put("modifiable", "false");
        retrievalStore.initialize(attributes, (CredentialStore.ProtectionParameter)this.storeProtection, null);
        PasswordCredential retrievedCredential = (PasswordCredential)retrievalStore.retrieve("key", PasswordCredential.class, null, null, null);
        ClearPasswordSpec retrievedPassword = (ClearPasswordSpec)this.passwordFactory.getKeySpec(retrievedCredential.getPassword(), ClearPasswordSpec.class);
        Assert.assertArrayEquals((char[])this.secretPassword, (char[])retrievedPassword.getEncodedPassword());
    }

    @Test
    public void multipleCredentialTypes() throws Exception {
        KeyStoreCredentialStore originalStore = new KeyStoreCredentialStore();
        File keyStoreFile = new File(this.tmp.getRoot(), "keystore");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("location", keyStoreFile.getAbsolutePath());
        attributes.put("create", Boolean.TRUE.toString());
        attributes.put("keyStoreType", this.keyStoreFormat);
        originalStore.initialize(attributes, (CredentialStore.ProtectionParameter)this.storeProtection, null);
        originalStore.store("key", (Credential)this.storedPasswordCredential, null);
        originalStore.store("key", (Credential)this.storedSecretKeyCredential, null);
        originalStore.flush();
        Assert.assertTrue((boolean)keyStoreFile.exists());
        KeyStoreCredentialStore retrievalStore = new KeyStoreCredentialStore();
        retrievalStore.initialize(attributes, (CredentialStore.ProtectionParameter)this.storeProtection, null);
        Set aliases = retrievalStore.getAliases();
        Assert.assertEquals((String)"Expected alias count", (long)1L, (long)aliases.size());
        Assert.assertTrue((String)"Expected alias 'key'", (boolean)aliases.contains("key"));
        PasswordCredential retrievedPasswordCredential = (PasswordCredential)retrievalStore.retrieve("key", PasswordCredential.class, null, null, null);
        ClearPasswordSpec retrievedPassword = (ClearPasswordSpec)this.passwordFactory.getKeySpec(retrievedPasswordCredential.getPassword(), ClearPasswordSpec.class);
        Assert.assertArrayEquals((char[])this.secretPassword, (char[])retrievedPassword.getEncodedPassword());
        SecretKeyCredential retrievedSecretKeyCredential = (SecretKeyCredential)retrievalStore.retrieve("key", SecretKeyCredential.class, null, null, null);
        Assert.assertEquals((String)"Expect SecretKeys to match", (Object)this.storedSecretKeyCredential.getSecretKey(), (Object)retrievedSecretKeyCredential.getSecretKey());
        retrievalStore.remove("key", PasswordCredential.class, null, null);
        aliases = retrievalStore.getAliases();
        Assert.assertEquals((String)"Expected alias count", (long)1L, (long)aliases.size());
        Assert.assertTrue((String)"Expected alias 'key'", (boolean)aliases.contains("key"));
        retrievalStore.remove("key", SecretKeyCredential.class, null, null);
        aliases = retrievalStore.getAliases();
        Assert.assertEquals((String)"Expected alias count", (long)0L, (long)aliases.size());
    }

    @Test
    public void symbolicLinkLocation() throws Exception {
        KeyStoreCredentialStore originalStore = new KeyStoreCredentialStore();
        File keyStoreFile = new File(this.tmp.getRoot(), "keystore");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("location", keyStoreFile.getAbsolutePath());
        attributes.put("create", Boolean.TRUE.toString());
        attributes.put("keyStoreType", "JCEKS");
        originalStore.initialize(attributes, (CredentialStore.ProtectionParameter)this.storeProtection, null);
        originalStore.store("key", (Credential)this.storedPasswordCredential, null);
        originalStore.flush();
        Assert.assertTrue((boolean)keyStoreFile.exists());
        KeyStoreCredentialStore retrievalStore = new KeyStoreCredentialStore();
        File symbolicLinkFile = new File(this.tmp.getRoot(), "link");
        Assume.assumeTrue((String)"Running on Windows without administrator privileges, test skipped.", (boolean)this.createSymbolicLink(symbolicLinkFile, keyStoreFile));
        HashMap<String, String> attributesRetrieval = new HashMap<String, String>();
        attributesRetrieval.put("location", symbolicLinkFile.getAbsolutePath());
        attributesRetrieval.put("keyStoreType", "JCEKS");
        retrievalStore.initialize(attributesRetrieval, (CredentialStore.ProtectionParameter)this.storeProtection, null);
        retrievalStore.store("key2", (Credential)this.storedPasswordCredential, null);
        retrievalStore.flush();
        Assert.assertTrue((boolean)Files.isSymbolicLink(Paths.get(symbolicLinkFile.getAbsolutePath(), new String[0])));
    }

    private boolean createSymbolicLink(File symbolicLinkFile, File targetFile) {
        try {
            Files.createSymbolicLink(Paths.get(symbolicLinkFile.getAbsolutePath(), new String[0]), Paths.get(targetFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

