/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.impl.MapCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

public class MapCredentialStoreTest {
    private static final String KEY = "key";
    private char[] secretPassword;
    private PasswordCredential storedPasswordCredential;

    @Before
    public void prepareEnvironment() {
        this.secretPassword = "password".toCharArray();
        this.storedPasswordCredential = new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])this.secretPassword));
    }

    @Test
    public void testSingleEntryStore() throws Exception {
        MapCredentialStore mapCredentialStore = new MapCredentialStore();
        mapCredentialStore.store(KEY, (Credential)this.storedPasswordCredential, null);
        Assert.assertTrue((boolean)mapCredentialStore.exists(KEY, PasswordCredential.class));
    }

    @Test
    public void testSingleEntryStoreAndRetrieve() throws Exception {
        MapCredentialStore mapCredentialStore = new MapCredentialStore();
        mapCredentialStore.store(KEY, (Credential)this.storedPasswordCredential, null);
        Set aliases = mapCredentialStore.getAliases();
        Assert.assertEquals((String)"Expected alias count", (long)1L, (long)aliases.size());
        Assert.assertTrue((String)"Expected alias 'key'", (boolean)aliases.contains(KEY));
        PasswordCredential retrievedPasswordCredential = (PasswordCredential)mapCredentialStore.retrieve(KEY, PasswordCredential.class, null, null, null);
        Assert.assertEquals((Object)this.storedPasswordCredential, (Object)retrievedPasswordCredential);
    }

    @Test
    public void testSingleEntryStoreAndRemove() throws Exception {
        MapCredentialStore mapCredentialStore = new MapCredentialStore();
        mapCredentialStore.store(KEY, (Credential)this.storedPasswordCredential, null);
        Set aliases = mapCredentialStore.getAliases();
        Assert.assertEquals((String)"Expected alias count", (long)1L, (long)aliases.size());
        Assert.assertTrue((String)"Expected alias 'key'", (boolean)aliases.contains(KEY));
        mapCredentialStore.remove(KEY, PasswordCredential.class, null, null);
        PasswordCredential retrievedPasswordCredential = (PasswordCredential)mapCredentialStore.retrieve(KEY, PasswordCredential.class, null, null, null);
        Assert.assertNull((Object)retrievedPasswordCredential);
    }
}

