/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.wildfly.security.http.oidc.AccessAndIDTokenResponse;
import org.wildfly.security.http.oidc.ClientCredentialsProviderUtils;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcException;
import org.wildfly.security.jose.util.JsonSerialization;

public class ServerRequest {
    private static final int BUFFER_LENGTH = 4096;

    public static AccessAndIDTokenResponse invokeRefresh(OidcClientConfiguration deployment, String refreshToken) throws IOException, HttpFailure {
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        formparams.add((NameValuePair)new BasicNameValuePair("refresh_token", refreshToken));
        HttpPost post = new HttpPost(deployment.getTokenUrl());
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)form);
        HttpResponse response = deployment.getClient().execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            throw new HttpFailure(status, null);
        }
        InputStream is = entity.getContent();
        try {
            int c;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            byte[] bytes = os.toByteArray();
            String json = new String(bytes);
            try {
                AccessAndIDTokenResponse accessAndIDTokenResponse = (AccessAndIDTokenResponse)JsonSerialization.readValue((String)json, AccessAndIDTokenResponse.class);
                return accessAndIDTokenResponse;
            }
            catch (IOException e) {
                throw new IOException(json, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void invokeLogout(OidcClientConfiguration deployment, String refreshToken) throws IOException, HttpFailure {
        HttpClient client = deployment.getClient();
        String uri = deployment.getLogoutUrl();
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("refresh_token", refreshToken));
        HttpPost post = new HttpPost(uri);
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)form);
        HttpResponse response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 204) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            return;
        }
        InputStream is = entity.getContent();
        if (is != null) {
            is.close();
        }
    }

    public static AccessAndIDTokenResponse invokeAccessCodeToToken(OidcClientConfiguration deployment, String code, String redirectUri) throws IOException, HttpFailure {
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        formparams.add((NameValuePair)new BasicNameValuePair("code", code));
        formparams.add((NameValuePair)new BasicNameValuePair("redirect_uri", redirectUri));
        HttpPost post = new HttpPost(deployment.getTokenUrl());
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)form);
        HttpResponse response = deployment.getClient().execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            throw new HttpFailure(status, null);
        }
        InputStream is = entity.getContent();
        try {
            int c;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            byte[] bytes = os.toByteArray();
            String json = new String(bytes);
            try {
                AccessAndIDTokenResponse accessAndIDTokenResponse = (AccessAndIDTokenResponse)JsonSerialization.readValue((String)json, AccessAndIDTokenResponse.class);
                return accessAndIDTokenResponse;
            }
            catch (IOException e) {
                throw new IOException(json, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void invokeRegisterNodeForKeycloak(OidcClientConfiguration deployment, String host) throws HttpFailure, IOException {
        String registerNodeUrl = deployment.getRegisterNodeUrl();
        ServerRequest.invokeClientManagementRequestForKeycloak(deployment, host, registerNodeUrl);
    }

    public static void invokeUnregisterNodeForKeycloak(OidcClientConfiguration deployment, String host) throws HttpFailure, IOException {
        String unregisterNodeUrl = deployment.getUnregisterNodeUrl();
        ServerRequest.invokeClientManagementRequestForKeycloak(deployment, host, unregisterNodeUrl);
    }

    public static void invokeClientManagementRequestForKeycloak(OidcClientConfiguration deployment, String host, String endpointUrl) throws HttpFailure, IOException {
        if (endpointUrl == null) {
            throw new IOException("You need to configure URI for register/unregister node for application " + deployment.getResourceName());
        }
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("client_cluster_host", host));
        HttpPost post = new HttpPost(endpointUrl);
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        HttpResponse response = deployment.getClient().execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        if (status != 204) {
            HttpEntity entity = response.getEntity();
            ServerRequest.error(status, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(int status, HttpEntity entity) throws HttpFailure, IOException {
        String body = null;
        if (entity != null) {
            InputStream is = entity.getContent();
            try {
                body = ServerRequest.readString(is, Charset.defaultCharset());
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new HttpFailure(status, body);
    }

    private static String readString(InputStream in, Charset charset) throws IOException {
        int wasRead;
        char[] buffer = new char[4096];
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        do {
            if ((wasRead = reader.read(buffer, 0, 4096)) <= 0) continue;
            builder.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        return builder.toString();
    }

    public static AccessAndIDTokenResponse getBearerToken(OidcClientConfiguration oidcClientConfiguration, String username, String password) throws Exception {
        AccessAndIDTokenResponse tokenResponse;
        HttpClient client = oidcClientConfiguration.getClient();
        HttpPost post = new HttpPost(oidcClientConfiguration.getTokenUrl());
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("grant_type", "password"));
        formparams.add((NameValuePair)new BasicNameValuePair("username", username));
        formparams.add((NameValuePair)new BasicNameValuePair("password", password));
        ClientCredentialsProviderUtils.setClientCredentials(oidcClientConfiguration, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        HttpResponse response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            EntityUtils.consumeQuietly((HttpEntity)entity);
            throw ElytronMessages.log.unableToObtainToken(status);
        }
        if (entity == null) {
            throw ElytronMessages.log.noMessageEntity();
        }
        try (InputStream is = entity.getContent();){
            tokenResponse = (AccessAndIDTokenResponse)JsonSerialization.readValue((InputStream)is, AccessAndIDTokenResponse.class);
        }
        return tokenResponse;
    }

    public static String getRequestUri(String request, OidcClientConfiguration deployment) throws OidcException {
        String string;
        block12: {
            HttpResponse response;
            if (deployment.getPushedAuthorizationRequestEndpoint() == null) {
                throw ElytronMessages.log.pushedAuthorizationRequestEndpointNotAvailable();
            }
            HttpPost parRequest = new HttpPost(deployment.getPushedAuthorizationRequestEndpoint());
            ArrayList<NameValuePair> formParams = new ArrayList<NameValuePair>();
            formParams.add((NameValuePair)new BasicNameValuePair("request", request));
            ClientCredentialsProviderUtils.setClientCredentials(deployment, parRequest, formParams);
            UrlEncodedFormEntity form = new UrlEncodedFormEntity(formParams, StandardCharsets.UTF_8);
            parRequest.setEntity((HttpEntity)form);
            try {
                response = deployment.getClient().execute((HttpUriRequest)parRequest);
            }
            catch (Exception e) {
                throw ElytronMessages.log.failedToSendPushedAuthorizationRequest(e);
            }
            if (response.getStatusLine().getStatusCode() != 201) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw ElytronMessages.log.unexpectedResponseCodeFromOidcProvider(response.getStatusLine().getStatusCode());
            }
            InputStream inputStream = response.getEntity().getContent();
            try {
                JwtClaims jwt = JwtClaims.parse((String)ServerRequest.readString(inputStream, StandardCharsets.UTF_8));
                string = jwt.getClaimValueAsString("request_uri");
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidJwtException e) {
                    throw ElytronMessages.log.failedToDecodeRequestUri((Exception)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static class HttpFailure
    extends Exception {
        private final int status;
        private final String error;

        public HttpFailure(int status, String error) {
            this.status = status;
            this.error = error;
        }

        public int getStatus() {
            return this.status;
        }

        public String getError() {
            return this.error;
        }
    }
}

