package org.wildfly.security.auth.realm.ldap;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import javax.naming.NamingException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-07T10:05:27-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String emptyParameter = "ELY00002: Parameter %s is empty";
    protected String emptyParameter$str() {
        return emptyParameter;
    }
    @Override
    public final IllegalArgumentException emptyParameter(final String parameter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyParameter$str(), parameter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String builderAlreadyBuilt = "ELY00003: This builder has already been built";
    protected String builderAlreadyBuilt$str() {
        return builderAlreadyBuilt;
    }
    @Override
    public final IllegalStateException builderAlreadyBuilt() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), builderAlreadyBuilt$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unrecognizedAlgorithm = "ELY00004: Unrecognized algorithm \"%s\"";
    protected String unrecognizedAlgorithm$str() {
        return unrecognizedAlgorithm;
    }
    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unrecognizedAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void credentialDestroyingFailed(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, credentialDestroyingFailed$str());
    }
    private static final String credentialDestroyingFailed = "ELY00007: Credential destroying failed";
    protected String credentialDestroyingFailed$str() {
        return credentialDestroyingFailed;
    }
    private static final String couldNotObtainCredential = "ELY01041: Could not obtain credential";
    protected String couldNotObtainCredential$str() {
        return couldNotObtainCredential;
    }
    @Override
    public final RuntimeException couldNotObtainCredential() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotObtainCredential$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainCredentialWithCause = "ELY01042: Could not obtain credential";
    protected String couldNotObtainCredentialWithCause$str() {
        return couldNotObtainCredentialWithCause;
    }
    @Override
    public final RuntimeException couldNotObtainCredentialWithCause(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotObtainCredentialWithCause$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String insufficientDataToFormDigestAndSalt = "ELY01053: Insufficient data to form a digest and a salt";
    protected String insufficientDataToFormDigestAndSalt$str() {
        return insufficientDataToFormDigestAndSalt;
    }
    @Override
    public final InvalidKeySpecException insufficientDataToFormDigestAndSalt() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), insufficientDataToFormDigestAndSalt$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSalt2 = "ELY01054: Invalid salt \"%s%s\"";
    protected String invalidSalt2$str() {
        return invalidSalt2;
    }
    @Override
    public final IllegalArgumentException invalidSalt(final char lo, final char hi) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSalt2$str(), lo, hi));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRounds = "ELY01055: Invalid rounds \"%s%s%s%s\"";
    protected String invalidRounds$str() {
        return invalidRounds;
    }
    @Override
    public final IllegalArgumentException invalidRounds(final char b0, final char b1, final char b2, final char b3) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRounds$str(), b0, b1, b2, b3));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSalt4 = "ELY01056: Invalid salt \"%s%s%s%s\"";
    protected String invalidSalt4$str() {
        return invalidSalt4;
    }
    @Override
    public final IllegalArgumentException invalidSalt(final char b0, final char b1, final char b2, final char b3) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSalt4$str(), b0, b1, b2, b3));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDirContextSupplierSet = "ELY01057: No DirContext supplier set";
    protected String noDirContextSupplierSet$str() {
        return noDirContextSupplierSet;
    }
    @Override
    public final IllegalStateException noDirContextSupplierSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noDirContextSupplierSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPrincipalMappingDefinition = "ELY01058: No principal mapping definition";
    protected String noPrincipalMappingDefinition$str() {
        return noPrincipalMappingDefinition;
    }
    @Override
    public final IllegalStateException noPrincipalMappingDefinition() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noPrincipalMappingDefinition$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainPrincipal = "ELY01060: Could not obtain principal";
    protected String couldNotObtainPrincipal$str() {
        return couldNotObtainPrincipal;
    }
    @Override
    public final RuntimeException couldNotObtainPrincipal() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotObtainPrincipal$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noProviderUrlSet = "ELY01062: No provider URL has been set";
    protected String noProviderUrlSet$str() {
        return noProviderUrlSet;
    }
    @Override
    public final IllegalStateException noProviderUrlSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noProviderUrlSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidName = "ELY01064: Invalid identity name";
    protected String invalidName$str() {
        return invalidName;
    }
    @Override
    public final IllegalArgumentException invalidName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmFailedObtainAttributes = "ELY01079: Ldap-backed realm failed to obtain attributes for entry [%s]";
    protected String ldapRealmFailedObtainAttributes$str() {
        return ldapRealmFailedObtainAttributes;
    }
    @Override
    public final RuntimeException ldapRealmFailedObtainAttributes(final String dn, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), ldapRealmFailedObtainAttributes$str(), dn), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmInvalidRdnForAttribute = "ELY01080: Attribute [%s] value [%s] must be in X.500 format in order to obtain RDN [%s].";
    protected String ldapRealmInvalidRdnForAttribute$str() {
        return ldapRealmInvalidRdnForAttribute;
    }
    @Override
    public final RuntimeException ldapRealmInvalidRdnForAttribute(final String attributeName, final String value, final String rdn, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), ldapRealmInvalidRdnForAttribute$str(), attributeName, value, rdn), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmIdentityNotExists = "ELY01083: Ldap-backed realm cannot to obtain not existing identity \"%s\"";
    protected String ldapRealmIdentityNotExists$str() {
        return ldapRealmIdentityNotExists;
    }
    @Override
    public final RealmUnavailableException ldapRealmIdentityNotExists(final String identity) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmIdentityNotExists$str(), identity));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmErrorWhileConsumingResultsFromSearch = "ELY01084: Error while consuming results from search. SearchDn [%s], Filter [%s], Filter Args [%s].";
    protected String ldapRealmErrorWhileConsumingResultsFromSearch$str() {
        return ldapRealmErrorWhileConsumingResultsFromSearch;
    }
    @Override
    public final RuntimeException ldapRealmErrorWhileConsumingResultsFromSearch(final String searchDn, final String filter, final String filterArgs, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), ldapRealmErrorWhileConsumingResultsFromSearch$str(), searchDn, filter, filterArgs), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmsPersisterNotSupported = "ELY01085: LDAP realm persister does not support given credential type";
    protected String ldapRealmsPersisterNotSupported$str() {
        return ldapRealmsPersisterNotSupported;
    }
    @Override
    public final RealmUnavailableException ldapRealmsPersisterNotSupported() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmsPersisterNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmCredentialPersistingFailed = "ELY01086: Persisting credential %s into Ldap-backed realm failed. Identity dn: \"%s\"";
    protected String ldapRealmCredentialPersistingFailed$str() {
        return ldapRealmCredentialPersistingFailed;
    }
    @Override
    public final RealmUnavailableException ldapRealmCredentialPersistingFailed(final String credential, final String dn, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmCredentialPersistingFailed$str(), credential, dn), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmCredentialClearingFailed = "ELY01087: Clearing credentials from Ldap-backed realm failed. Identity dn: \"%s\"";
    protected String ldapRealmCredentialClearingFailed$str() {
        return ldapRealmCredentialClearingFailed;
    }
    @Override
    public final RealmUnavailableException ldapRealmCredentialClearingFailed(final String dn, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmCredentialClearingFailed$str(), dn), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownLdapPasswordScheme = "ELY01090: Unknown LDAP password scheme";
    protected String unknownLdapPasswordScheme$str() {
        return unknownLdapPasswordScheme;
    }
    @Override
    public final InvalidKeySpecException unknownLdapPasswordScheme() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), unknownLdapPasswordScheme$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchIdentity = "ELY01096: No such identity";
    protected String noSuchIdentity$str() {
        return noSuchIdentity;
    }
    @Override
    public final RealmUnavailableException noSuchIdentity() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), noSuchIdentity$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmFailedDeleteIdentityFromServer = "ELY01097: Ldap-backed realm failed to delete identity from server";
    protected String ldapRealmFailedDeleteIdentityFromServer$str() {
        return ldapRealmFailedDeleteIdentityFromServer;
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedDeleteIdentityFromServer(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmFailedDeleteIdentityFromServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmFailedCreateIdentityOnServer = "ELY01098: Ldap-backed realm failed to create identity on server";
    protected String ldapRealmFailedCreateIdentityOnServer$str() {
        return ldapRealmFailedCreateIdentityOnServer;
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedCreateIdentityOnServer(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmFailedCreateIdentityOnServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmNotConfiguredToSupportCreatingIdentities = "ELY01099: Ldap-backed realm is not configured to allow create new identities (new identity parent and attributes has to be set)";
    protected String ldapRealmNotConfiguredToSupportCreatingIdentities$str() {
        return ldapRealmNotConfiguredToSupportCreatingIdentities;
    }
    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportCreatingIdentities() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmNotConfiguredToSupportCreatingIdentities$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmCannotSetAttributeWithoutMapping = "ELY01100: Ldap-backed realm does not contain mapping to set Elytron attribute \"%s\" of identity \"%s\"";
    protected String ldapRealmCannotSetAttributeWithoutMapping$str() {
        return ldapRealmCannotSetAttributeWithoutMapping;
    }
    @Override
    public final RealmUnavailableException ldapRealmCannotSetAttributeWithoutMapping(final String attribute, final String identity) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmCannotSetAttributeWithoutMapping$str(), attribute, identity));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ldapRealmDoesNotSupportSettingFilteredAttribute(final String attribute, final String identity) {
        super.log.logf(FQCN, WARN, null, ldapRealmDoesNotSupportSettingFilteredAttribute$str(), attribute, identity);
    }
    private static final String ldapRealmDoesNotSupportSettingFilteredAttribute = "ELY01101: Ldap-backed realm does not support setting of filtered attribute \"%s\" (identity \"%s\")";
    protected String ldapRealmDoesNotSupportSettingFilteredAttribute$str() {
        return ldapRealmDoesNotSupportSettingFilteredAttribute;
    }
    private static final String ldapRealmRequiresExactlyOneRdnAttribute = "ELY01102: Ldap-backed realm requires exactly one value of attribute \"%s\" mapped to RDN (identity \"%s\")";
    protected String ldapRealmRequiresExactlyOneRdnAttribute$str() {
        return ldapRealmRequiresExactlyOneRdnAttribute;
    }
    @Override
    public final RealmUnavailableException ldapRealmRequiresExactlyOneRdnAttribute(final String attribute, final String identity) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmRequiresExactlyOneRdnAttribute$str(), attribute, identity));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmAttributesSettingFailed = "ELY01103: Ldap-backed realm failed to set attributes of identity \"%s\"";
    protected String ldapRealmAttributesSettingFailed$str() {
        return ldapRealmAttributesSettingFailed;
    }
    @Override
    public final RealmUnavailableException ldapRealmAttributesSettingFailed(final String identity, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmAttributesSettingFailed$str(), identity), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmIdentitySearchFailed = "ELY01108: Ldap-backed realm identity search failed";
    protected String ldapRealmIdentitySearchFailed$str() {
        return ldapRealmIdentitySearchFailed;
    }
    @Override
    public final RealmUnavailableException ldapRealmIdentitySearchFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmIdentitySearchFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmNotConfiguredToSupportIteratingOverIdentities = "ELY01109: Ldap-backed realm is not configured to allow iterate over identities (iterator filter has to be set)";
    protected String ldapRealmNotConfiguredToSupportIteratingOverIdentities$str() {
        return ldapRealmNotConfiguredToSupportIteratingOverIdentities;
    }
    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportIteratingOverIdentities() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmNotConfiguredToSupportIteratingOverIdentities$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmFailedToObtainContext = "ELY01125: Ldap-backed realm failed to obtain context";
    protected String ldapRealmFailedToObtainContext$str() {
        return ldapRealmFailedToObtainContext;
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedToObtainContext(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmFailedToObtainContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ldapRealmDeferRegistration() {
        super.log.logf(FQCN, INFO, null, ldapRealmDeferRegistration$str());
    }
    private static final String ldapRealmDeferRegistration = "ELY01146: LDAP Realm unable to register listener, defering action.";
    protected String ldapRealmDeferRegistration$str() {
        return ldapRealmDeferRegistration;
    }
    private static final String ldapInvalidLdapName = "ELY01147: Invalid LDAP name [%s]";
    protected String ldapInvalidLdapName$str() {
        return ldapInvalidLdapName;
    }
    @Override
    public final RuntimeException ldapInvalidLdapName(final String name, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), ldapInvalidLdapName$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String obtainingDirContextCredentialFromAuthenticationContextFailed = "ELY01150: Obtaining DirContext credentials from AuthenticationContext failed.";
    protected String obtainingDirContextCredentialFromAuthenticationContextFailed$str() {
        return obtainingDirContextCredentialFromAuthenticationContextFailed;
    }
    @Override
    public final NamingException obtainingDirContextCredentialFromAuthenticationContextFailed(final Throwable cause) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), obtainingDirContextCredentialFromAuthenticationContextFailed$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String directLdapVerificationFailed = "ELY01153: Direct LDAP verification failed with DN [%s] and absolute DN [%s]";
    protected String directLdapVerificationFailed$str() {
        return directLdapVerificationFailed;
    }
    @Override
    public final RealmUnavailableException directLdapVerificationFailed(final String distinguishedName, final String absoluteName, final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), directLdapVerificationFailed$str(), distinguishedName, absoluteName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String threadLocalSslSocketFactoryThreadLocalNotSet = "ELY04025: DirContext tries to connect without ThreadLocalSSLSocketFactory thread local setting";
    protected String threadLocalSslSocketFactoryThreadLocalNotSet$str() {
        return threadLocalSslSocketFactoryThreadLocalNotSet;
    }
    @Override
    public final IllegalStateException threadLocalSslSocketFactoryThreadLocalNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), threadLocalSslSocketFactoryThreadLocalNotSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
