package org.wildfly.security.manager._private;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import java.security.AccessControlException;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.security.CodeSource;
import java.security.Permission;
import java.lang.ClassLoader;
import java.lang.Class;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-11-07T16:28:21+0000")
public class SecurityMessages_$logger implements SecurityMessages, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SecurityMessages_$logger.class.getName();
    public SecurityMessages_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void accessCheckFailed(final Permission permission, final CodeSource codeSource, final ClassLoader classLoader, final String principals) {
        log.logf(FQCN, DEBUG, null, accessCheckFailed4$str(), permission, codeSource, classLoader, principals);
    }
    protected String accessCheckFailed4$str() {
        return "Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\", principals \"%s\")";
    }
    @Override
    public final void accessCheckFailed(final Permission permission, final CodeSource codeSource, final ClassLoader classLoader) {
        log.logf(FQCN, DEBUG, null, accessCheckFailed3$str(), permission, codeSource, classLoader);
    }
    protected String accessCheckFailed3$str() {
        return "Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\")";
    }
    protected String accessControlException$str() {
        return "WFSM000001: Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\")";
    }
    @Override
    public final AccessControlException accessControlException(final Permission permission, final Permission permission_, final CodeSource codeSource, final ClassLoader classLoader) {
        final AccessControlException result = new AccessControlException(String.format(getLoggingLocale(), accessControlException$str(), permission_, codeSource, classLoader), permission);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String secMgrChange$str() {
        return "WFSM000002: Security manager may not be changed";
    }
    @Override
    public final SecurityException secMgrChange() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), secMgrChange$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownContext$str() {
        return "WFSM000003: Unknown security context type";
    }
    @Override
    public final SecurityException unknownContext() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unknownContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidName$str() {
        return "WFSM000006: Invalid permission name '%s'";
    }
    @Override
    public final IllegalArgumentException invalidName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readOnlyPermCollection$str() {
        return "WFSM000007: Permission collection is read-only";
    }
    @Override
    public final SecurityException readOnlyPermCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermCollection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongPermType$str() {
        return "WFSM000008: Invalid permission (expected an instance of %s, but got %s)";
    }
    @Override
    public final IllegalArgumentException wrongPermType(final Class<? extends Permission> expectedType, final Permission permission) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongPermType$str(), expectedType, permission));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
