/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.realm.token.test.util;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSASSASigner;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import org.wildfly.security.realm.token.test.util.RsaJwk;

public final class JwtTestUtil {
    public static JsonObject jwksToJson(RsaJwk ... jwks) {
        JsonArrayBuilder jab = Json.createArrayBuilder();
        for (int i = 0; i < jwks.length; ++i) {
            JsonObjectBuilder jwk = Json.createObjectBuilder().add("kty", jwks[i].getKty()).add("alg", jwks[i].getAlg()).add("kid", jwks[i].getKid()).add("n", jwks[i].getN()).add("e", jwks[i].getE());
            jab.add(jwk);
        }
        return Json.createObjectBuilder().add("keys", jab).build();
    }

    public static String createJwt(KeyPair keyPair, int expirationOffset, int notBeforeOffset) throws Exception {
        return JwtTestUtil.createJwt(keyPair, expirationOffset, notBeforeOffset, null, null);
    }

    public static String createJwt(KeyPair keyPair, int expirationOffset) throws Exception {
        return JwtTestUtil.createJwt(keyPair, expirationOffset, -1);
    }

    public static String createJwt(KeyPair keyPair, int expirationOffset, int notBeforeOffset, String kid, URI jku) throws Exception {
        PrivateKey privateKey = keyPair.getPrivate();
        RSASSASigner signer = new RSASSASigner(privateKey);
        JsonObjectBuilder claimsBuilder = JwtTestUtil.createClaims(expirationOffset, notBeforeOffset);
        JWSHeader.Builder headerBuilder = new JWSHeader.Builder(JWSAlgorithm.RS256).type(new JOSEObjectType("jwt"));
        if (jku != null) {
            headerBuilder.jwkURL(jku);
        }
        if (kid != null) {
            headerBuilder.keyID(kid);
        }
        JWSObject jwsObject = new JWSObject(headerBuilder.build(), new Payload(claimsBuilder.build().toString()));
        jwsObject.sign((JWSSigner)signer);
        return jwsObject.serialize();
    }

    public static String createJwt(KeyPair keyPair) throws Exception {
        return JwtTestUtil.createJwt(keyPair, 60);
    }

    public static JsonObjectBuilder createClaims(int expirationOffset, int notBeforeOffset) {
        return JwtTestUtil.createClaims(expirationOffset, notBeforeOffset, null);
    }

    public static JsonObjectBuilder createClaims(int expirationOffset, int notBeforeOffset, JsonObject additionalClaims) {
        JsonObjectBuilder claimsBuilder = Json.createObjectBuilder().add("active", true).add("sub", "elytron@jboss.org").add("iss", "elytron-oauth2-realm").add("aud", (JsonValue)Json.createArrayBuilder().add("my-app-valid").add("third-app-valid").add("another-app-valid").build()).add("exp", System.currentTimeMillis() / 1000L + (long)expirationOffset);
        if (additionalClaims != null) {
            for (String name : additionalClaims.keySet()) {
                JsonValue value = (JsonValue)additionalClaims.get((Object)name);
                claimsBuilder.add(name, value);
            }
        }
        if (notBeforeOffset > 0) {
            claimsBuilder.add("nbf", System.currentTimeMillis() / 1000L + (long)notBeforeOffset);
        }
        return claimsBuilder;
    }

    public static RsaJwk createRsaJwk(KeyPair keyPair, String kid) {
        RSAPublicKey pk = (RSAPublicKey)keyPair.getPublic();
        RsaJwk jwk = new RsaJwk();
        jwk.setAlg("RS256");
        jwk.setKid(kid);
        jwk.setKty("RSA");
        jwk.setE(Base64.getUrlEncoder().withoutPadding().encodeToString(JwtTestUtil.toBase64urlUInt(pk.getPublicExponent())));
        jwk.setN(Base64.getUrlEncoder().withoutPadding().encodeToString(JwtTestUtil.toBase64urlUInt(pk.getModulus())));
        return jwk;
    }

    public static Dispatcher createTokenDispatcher(final String response) {
        return new Dispatcher(){

            public MockResponse dispatch(RecordedRequest recordedRequest) {
                return new MockResponse().setBody(response);
            }
        };
    }

    private static byte[] toBase64urlUInt(BigInteger bigInt) {
        int i;
        byte[] bytes = bigInt.toByteArray();
        for (i = 0; i < bytes.length && bytes[i] == 0; ++i) {
        }
        if (i > 0 && i < bytes.length) {
            return Arrays.copyOfRange(bytes, i, bytes.length);
        }
        return bytes;
    }
}

