/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.realm.token.test.util;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import org.wildfly.security.realm.token.test.util.RsaJwk;

public class JwkTestUtil {
    public static JsonObject jwksToJson(RsaJwk ... jwks) {
        JsonArrayBuilder jab = Json.createArrayBuilder();
        for (int i = 0; i < jwks.length; ++i) {
            JsonObjectBuilder jwk = Json.createObjectBuilder().add("kty", jwks[i].getKty()).add("alg", jwks[i].getAlg()).add("kid", jwks[i].getKid()).add("n", jwks[i].getN()).add("e", jwks[i].getE());
            if (jwks[i].getUse() != null) {
                jwk.add("use", jwks[i].getUse());
            } else if (jwks[i].getKeyOps() != null) {
                JsonArrayBuilder keyOpBuilder = Json.createArrayBuilder();
                for (String keyOp : jwks[i].getKeyOps()) {
                    keyOpBuilder.add(keyOp);
                }
                jwk.add("key_ops", keyOpBuilder);
            }
            jab.add(jwk);
        }
        return Json.createObjectBuilder().add("keys", jab).build();
    }

    public static RsaJwk createRsaJwk(KeyPair keyPair, String kid) {
        RSAPublicKey pk = (RSAPublicKey)keyPair.getPublic();
        RsaJwk jwk = new RsaJwk();
        jwk.setAlg("RS256");
        jwk.setKid(kid);
        jwk.setKty("RSA");
        jwk.setE(Base64.getUrlEncoder().withoutPadding().encodeToString(JwkTestUtil.toBase64urlUInt(pk.getPublicExponent())));
        jwk.setN(Base64.getUrlEncoder().withoutPadding().encodeToString(JwkTestUtil.toBase64urlUInt(pk.getModulus())));
        return jwk;
    }

    private static byte[] toBase64urlUInt(BigInteger bigInt) {
        int i;
        byte[] bytes = bigInt.toByteArray();
        for (i = 0; i < bytes.length && bytes[i] == 0; ++i) {
        }
        if (i > 0 && i < bytes.length) {
            return Arrays.copyOfRange(bytes, i, bytes.length);
        }
        return bytes;
    }
}

