/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.realm.token.test.util;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSASSASigner;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import org.wildfly.security.realm.token.test.util.JwkTestUtil;

public final class JwtTestUtil
extends JwkTestUtil {
    public static String createJwt(KeyPair keyPair, int expirationOffset, int notBeforeOffset) throws Exception {
        return JwtTestUtil.createJwt(keyPair, expirationOffset, notBeforeOffset, null, null);
    }

    public static String createJwt(KeyPair keyPair, int expirationOffset) throws Exception {
        return JwtTestUtil.createJwt(keyPair, expirationOffset, -1);
    }

    public static String createJwt(KeyPair keyPair, int expirationOffset, int notBeforeOffset, String kid, URI jku) throws Exception {
        PrivateKey privateKey = keyPair.getPrivate();
        RSASSASigner signer = new RSASSASigner(privateKey);
        JsonObjectBuilder claimsBuilder = JwtTestUtil.createClaims(expirationOffset, notBeforeOffset);
        JWSHeader.Builder headerBuilder = new JWSHeader.Builder(JWSAlgorithm.RS256).type(new JOSEObjectType("jwt"));
        if (jku != null) {
            headerBuilder.jwkURL(jku);
        }
        if (kid != null) {
            headerBuilder.keyID(kid);
        }
        JWSObject jwsObject = new JWSObject(headerBuilder.build(), new Payload(claimsBuilder.build().toString()));
        jwsObject.sign((JWSSigner)signer);
        return jwsObject.serialize();
    }

    public static String createJwt(KeyPair keyPair) throws Exception {
        return JwtTestUtil.createJwt(keyPair, 60);
    }

    public static JsonObjectBuilder createClaims(int expirationOffset, int notBeforeOffset) {
        return JwtTestUtil.createClaims(expirationOffset, notBeforeOffset, null);
    }

    public static JsonObjectBuilder createClaims(int expirationOffset, int notBeforeOffset, JsonObject additionalClaims) {
        JsonObjectBuilder claimsBuilder = Json.createObjectBuilder().add("active", true).add("sub", "elytron@jboss.org").add("iss", "elytron-oauth2-realm").add("aud", (JsonValue)Json.createArrayBuilder().add("my-app-valid").add("third-app-valid").add("another-app-valid").build()).add("exp", System.currentTimeMillis() / 1000L + (long)expirationOffset);
        if (additionalClaims != null) {
            for (String name : additionalClaims.keySet()) {
                JsonValue value = (JsonValue)additionalClaims.get((Object)name);
                claimsBuilder.add(name, value);
            }
        }
        if (notBeforeOffset > 0) {
            claimsBuilder.add("nbf", System.currentTimeMillis() / 1000L + (long)notBeforeOffset);
        }
        return claimsBuilder;
    }

    public static Dispatcher createTokenDispatcher(final String response) {
        return new Dispatcher(){

            public MockResponse dispatch(RecordedRequest recordedRequest) {
                return new MockResponse().setBody(response);
            }
        };
    }
}

